/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.BeforeSendSession;
import com.bugsnag.Bugsnag;
import com.bugsnag.Diagnostics;
import com.bugsnag.Report;
import com.bugsnag.SessionPayload;
import com.bugsnag.callbacks.Callback;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootVersion;
import org.springframework.context.annotation.Bean;

public class SpringBootConfiguration {
    @Autowired
    private Bugsnag bugsnag;

    @Bean
    Callback springBootVersionErrorCallback() {
        Callback callback = new Callback(){

            public void beforeNotify(Report report) {
                SpringBootConfiguration.this.addSpringRuntimeVersion(report.getDevice());
            }
        };
        this.bugsnag.addCallback(callback);
        return callback;
    }

    @Bean
    BeforeSendSession springBootVersionSessionCallback() {
        BeforeSendSession beforeSendSession = new BeforeSendSession(){

            public void beforeSendSession(SessionPayload payload) {
                SpringBootConfiguration.this.addSpringRuntimeVersion(payload.getDevice());
            }
        };
        this.bugsnag.addBeforeSendSession(beforeSendSession);
        return beforeSendSession;
    }

    private void addSpringRuntimeVersion(Map<String, Object> device) {
        Diagnostics.addDeviceRuntimeVersion(device, (String)"springBoot", (Object)SpringBootVersion.getVersion());
    }
}

