/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.maven.plugin;

import com.bugvm.compiler.AppCompiler;
import com.bugvm.compiler.config.Arch;
import com.bugvm.compiler.config.Config;
import com.bugvm.maven.plugin.AbstractBugVMMojo;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractBugVMBuildMojo
extends AbstractBugVMMojo {
    @Parameter(property="bugvm.archs")
    protected String archs;

    protected String getArchs() {
        return this.archs;
    }

    protected abstract boolean shouldArchive();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Config.Builder builder = this.configure(new Config.Builder()).skipInstall(false);
            if (this.getArchs() != null) {
                ArrayList<Arch> archs = new ArrayList<Arch>();
                for (String s : this.getArchs().trim().split(":")) {
                    archs.add(Arch.valueOf((String)s));
                }
                builder.archs(archs);
            }
            AppCompiler compiler = new AppCompiler(builder.build());
            compiler.build();
            if (this.shouldArchive()) {
                compiler.archive();
            } else {
                compiler.install();
            }
        }
        catch (IOException e) {
            if (this.shouldArchive()) {
                throw new MojoExecutionException("Failed to create archive", (Exception)e);
            }
            throw new MojoExecutionException("Failed to install", (Exception)e);
        }
    }
}

