/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.maven.plugin;

import com.bugvm.compiler.AppCompiler;
import com.bugvm.compiler.Version;
import com.bugvm.compiler.config.Arch;
import com.bugvm.compiler.config.Config;
import com.bugvm.compiler.config.OS;
import com.bugvm.compiler.log.Logger;
import com.bugvm.compiler.target.ios.ProvisioningProfile;
import com.bugvm.compiler.target.ios.SigningIdentity;
import com.bugvm.maven.plugin.MavenArtifactHandler;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

public abstract class AbstractBugVMMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @Parameter
    protected File home;
    @Parameter(property="bugvm.propertiesFile")
    protected File propertiesFile;
    @Parameter(property="bugvm.configFile")
    protected File configFile;
    @Parameter(property="bugvm.iosSignIdentity")
    protected String iosSignIdentity;
    @Parameter(property="bugvm.iosProvisioningProfile")
    protected String iosProvisioningProfile;
    @Parameter(property="bugvm.iosSkipSigning")
    protected boolean iosSkipSigning = false;
    @Parameter(property="bugvm.installDir", defaultValue="${project.build.directory}/bugvm")
    protected File installDir;
    @Parameter(property="bugvm.arch")
    protected String arch;
    @Parameter(property="bugvm.os")
    protected String os;
    @Parameter(property="bugvm.debug")
    protected String debug;
    @Parameter(property="bugvm.debugPort")
    protected int debugPort = -1;
    private Logger bugVMLogger;

    protected Config.Builder configure(Config.Builder builder) throws MojoExecutionException {
        builder.logger(this.getBugVMLogger());
        if (this.os != null) {
            builder.os(OS.valueOf((String)this.os));
        }
        if (this.propertiesFile != null) {
            if (!this.propertiesFile.exists()) {
                throw new MojoExecutionException("Invalid 'propertiesFile' specified for BugVM compile: " + this.propertiesFile);
            }
            try {
                this.getLog().debug((CharSequence)("Including properties file in BugVM compiler config: " + this.propertiesFile.getAbsolutePath()));
                builder.addProperties(this.propertiesFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to add properties file to BugVM config: " + this.propertiesFile);
            }
        }
        try {
            builder.readProjectProperties(this.project.getBasedir(), false);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read BugVM project properties file(s) in " + this.project.getBasedir().getAbsolutePath(), (Exception)e);
        }
        if (this.configFile != null) {
            if (!this.configFile.exists()) {
                throw new MojoExecutionException("Invalid 'configFile' specified for BugVM compile: " + this.configFile);
            }
            try {
                this.getLog().debug((CharSequence)("Loading config file for BugVM compiler: " + this.configFile.getAbsolutePath()));
                builder.read(this.configFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to read BugVM config file: " + this.configFile);
            }
        }
        try {
            builder.readProjectConfig(this.project.getBasedir(), false);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to read project BugVM config file in " + this.project.getBasedir().getAbsolutePath(), e);
        }
        Plugin plugin = this.project.getPlugin("com.bugvm:bugvm-maven");
        MavenProject p = this.project;
        while (p != null && plugin == null) {
            plugin = (Plugin)p.getPluginManagement().getPluginsAsMap().get("com.bugvm:bugvm-maven");
            if (plugin != null) continue;
            p = p.getParent();
        }
        if (plugin != null) {
            this.getLog().debug((CharSequence)("Reading BugVM plugin configuration from " + p.getFile().getAbsolutePath()));
            Xpp3Dom configDom = (Xpp3Dom)plugin.getConfiguration();
            if (configDom != null && configDom.getChild("config") != null) {
                StringWriter sw = new StringWriter();
                PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter((Writer)sw, "UTF-8", null);
                Xpp3DomWriter.write((XMLWriter)xmlWriter, (Xpp3Dom)configDom.getChild("config"));
                try {
                    builder.read((Reader)new StringReader(sw.toString()), this.project.getBasedir());
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Failed to read BugVM config embedded in POM", e);
                }
            }
        }
        File tmpDir = new File(this.project.getBuild().getDirectory(), "bugvm.tmp");
        try {
            FileUtils.deleteDirectory((File)tmpDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to clean output dir " + tmpDir, (Exception)e);
        }
        tmpDir.mkdirs();
        Config.Home home = null;
        try {
            home = Config.Home.find();
        }
        catch (Throwable xmlWriter) {
            // empty catch block
        }
        if (home == null || !home.isDev()) {
            home = new Config.Home(this.unpackBugVMDist());
        }
        builder.home(home).tmpDir(tmpDir).skipInstall(true).installDir(this.installDir);
        if (home.isDev()) {
            builder.useDebugLibs(Boolean.getBoolean("bugvm.useDebugLibs"));
            builder.dumpIntermediates(true);
        }
        if (this.debug != null && !this.debug.equals("false")) {
            builder.debug(true);
            if (this.debugPort != -1) {
                builder.addPluginArgument("debug:jdwpport=" + this.debugPort);
            }
            if ("clientmode".equals(this.debug)) {
                builder.addPluginArgument("debug:clientmode=true");
            }
        }
        if (this.iosSkipSigning) {
            builder.iosSkipSigning(true);
        } else {
            if (this.iosSignIdentity != null) {
                this.getLog().debug((CharSequence)("Using explicit iOS Signing identity: " + this.iosSignIdentity));
                builder.iosSignIdentity(SigningIdentity.find((List)SigningIdentity.list(), (String)this.iosSignIdentity));
            }
            if (this.iosProvisioningProfile != null) {
                this.getLog().debug((CharSequence)("Using explicit iOS provisioning profile: " + this.iosProvisioningProfile));
                builder.iosProvisioningProfile(ProvisioningProfile.find((List)ProvisioningProfile.list(), (String)this.iosProvisioningProfile));
            }
        }
        builder.clearClasspathEntries();
        try {
            for (Object object : this.project.getRuntimeClasspathElements()) {
                String path = (String)object;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Including classpath element for BugVM app: " + path));
                }
                builder.addClasspathEntry(new File(path));
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error resolving application classpath for BugVM build", (Exception)((Object)e));
        }
        return builder;
    }

    protected AppCompiler build(OS os, Arch arch, String targetType) throws MojoExecutionException, MojoFailureException {
        Config.Builder builder;
        this.getLog().info((CharSequence)("Building BugVM app for: " + os + " (" + arch + ")"));
        try {
            builder = new Config.Builder();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.configure(builder).os(os).arch(arch).targetType(targetType);
        try {
            this.getLog().info((CharSequence)"Compiling BugVM app, this could take a while, especially the first time round");
            AppCompiler compiler = new AppCompiler(builder.build());
            compiler.build();
            return compiler;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error building BugVM executable for app", (Exception)e);
        }
    }

    protected String getBugVMVersion() {
        return Version.getVersion();
    }

    protected File unpackBugVMDist() throws MojoExecutionException {
        Artifact distTarArtifact = this.resolveBugVMDistArtifact();
        File distTarFile = distTarArtifact.getFile();
        File unpackBaseDir = this.home != null ? this.home : new File(distTarFile.getParent(), "unpacked");
        if (unpackBaseDir.exists() && distTarArtifact.isSnapshot()) {
            this.getLog().debug((CharSequence)("Deleting directory for unpacked snapshots: " + unpackBaseDir));
            try {
                FileUtils.deleteDirectory((File)unpackBaseDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to delete " + unpackBaseDir, (Exception)e);
            }
        }
        this.unpack(distTarFile, unpackBaseDir);
        File unpackedDir = new File(unpackBaseDir, "bugvm-" + this.getBugVMVersion());
        return unpackedDir;
    }

    protected Artifact resolveBugVMDistArtifact() throws MojoExecutionException {
        MavenArtifactHandler handler = new MavenArtifactHandler("tar.gz");
        DefaultArtifact artifact = new DefaultArtifact("com.bugvm", "bugvm-dist", this.getBugVMVersion(), "", "tar.gz", "", (ArtifactHandler)handler);
        return this.resolveArtifact((Artifact)artifact);
    }

    protected Artifact resolveArtifact(Artifact artifact) throws MojoExecutionException {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setLocalRepository(this.localRepository);
        List remoteRepositories = this.project.getRemoteArtifactRepositories();
        request.setRemoteRepositories(remoteRepositories);
        this.getLog().debug((CharSequence)("Resolving artifact " + artifact));
        ArtifactResolutionResult result = this.artifactResolver.resolve(request);
        if (!result.isSuccess()) {
            throw new MojoExecutionException("Unable to resolve artifact: " + artifact);
        }
        Set resolvedArtifacts = result.getArtifacts();
        artifact = (Artifact)resolvedArtifacts.iterator().next();
        return artifact;
    }

    protected void unpack(File archive, File targetDirectory) throws MojoExecutionException {
        if (!targetDirectory.exists()) {
            this.getLog().info((CharSequence)("Extracting '" + archive + "' to: " + targetDirectory));
            if (!targetDirectory.mkdirs()) {
                throw new MojoExecutionException("Unable to create base directory to unpack into: " + targetDirectory);
            }
            try {
                UnArchiver unArchiver = this.archiverManager.getUnArchiver(archive);
                unArchiver.setSourceFile(archive);
                unArchiver.setDestDirectory(targetDirectory);
                unArchiver.extract();
            }
            catch (NoSuchArchiverException e) {
                throw new MojoExecutionException("Unable to unpack archive " + archive + " to " + targetDirectory, (Exception)((Object)e));
            }
            this.getLog().debug((CharSequence)("Archive '" + archive + "' unpacked to: " + targetDirectory));
        } else {
            this.getLog().debug((CharSequence)("Archive '" + archive + "' was already unpacked in: " + targetDirectory));
        }
    }

    protected Logger getBugVMLogger() {
        if (this.bugVMLogger == null) {
            this.bugVMLogger = new Logger(){

                public void debug(String s, Object ... objects) {
                    AbstractBugVMMojo.this.getLog().debug((CharSequence)String.format(s, objects));
                }

                public void info(String s, Object ... objects) {
                    AbstractBugVMMojo.this.getLog().info((CharSequence)String.format(s, objects));
                }

                public void warn(String s, Object ... objects) {
                    AbstractBugVMMojo.this.getLog().warn((CharSequence)String.format(s, objects));
                }

                public void error(String s, Object ... objects) {
                    AbstractBugVMMojo.this.getLog().error((CharSequence)String.format(s, objects));
                }
            };
        }
        return this.bugVMLogger;
    }
}

