/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.maven.plugin;

import com.bugvm.compiler.AppCompiler;
import com.bugvm.compiler.config.Arch;
import com.bugvm.compiler.config.Config;
import com.bugvm.compiler.config.OS;
import com.bugvm.compiler.target.LaunchParameters;
import com.bugvm.compiler.target.ios.DeviceType;
import com.bugvm.compiler.target.ios.IOSSimulatorLaunchParameters;
import com.bugvm.maven.plugin.AbstractBugVMMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractIOSSimulatorMojo
extends AbstractBugVMMojo {
    private DeviceType.DeviceFamily deviceFamily;
    @Parameter(property="bugvm.iosSimSdk")
    protected String sdk;
    @Parameter(property="bugvm.iosDeviceName")
    protected String deviceName;

    protected AbstractIOSSimulatorMojo(DeviceType.DeviceFamily deviceFamily) {
        this.deviceFamily = deviceFamily;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Arch arch = Arch.x86_64;
            if (this.arch != null && this.arch.equals(Arch.x86.toString())) {
                arch = Arch.x86;
            }
            AppCompiler compiler = this.build(OS.ios, arch, "ios");
            Config config = compiler.getConfig();
            IOSSimulatorLaunchParameters launchParameters = (IOSSimulatorLaunchParameters)config.getTarget().createLaunchParameters();
            DeviceType deviceType = DeviceType.getBestDeviceType((Arch)arch, (DeviceType.DeviceFamily)this.deviceFamily, (String)this.deviceName, (String)this.sdk);
            launchParameters.setDeviceType(deviceType);
            compiler.launch((LaunchParameters)launchParameters);
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Failed to launch IOS Simulator", t);
        }
    }
}

