/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.objc;

import com.bugvm.objc.ObjCObject;
import com.bugvm.objc.ObjCSuper;
import com.bugvm.objc.Selector;
import com.bugvm.rt.VM;
import com.bugvm.rt.bro.Bro;
import com.bugvm.rt.bro.Runtime;
import com.bugvm.rt.bro.Struct;
import com.bugvm.rt.bro.annotation.Bridge;
import com.bugvm.rt.bro.annotation.ByVal;
import com.bugvm.rt.bro.annotation.Library;
import com.bugvm.rt.bro.annotation.Pointer;
import com.bugvm.rt.bro.annotation.StructRet;
import com.bugvm.rt.bro.ptr.BytePtr;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

@Library(value="objc")
public class ObjCRuntime {
    private static final Map<Class<?>, Integer> structSizes = new HashMap();

    public static void bind() {
        Class caller = VM.getStackClasses((int)0, (int)1)[0];
        ObjCRuntime.bind(caller);
    }

    public static void bind(Class<?> c) {
        for (Method method : c.getDeclaredMethods()) {
            Class<?>[] paramTypes;
            Bridge bridge = method.getAnnotation(Bridge.class);
            if (bridge == null || bridge.symbol() != null && !"".equals(bridge.symbol()) || (paramTypes = method.getParameterTypes()).length < 2 || paramTypes[1] != Selector.class) continue;
            String symbol = null;
            if (paramTypes[0] == ObjCSuper.class) {
                symbol = "objc_msgSendSuper";
            } else if (ObjCObject.class.isAssignableFrom(paramTypes[0])) {
                symbol = "objc_msgSend";
            } else if (paramTypes[0] == Long.TYPE) {
                Annotation[] paramAnnos;
                for (Annotation a : paramAnnos = method.getParameterAnnotations()[0]) {
                    if (a.annotationType() != Pointer.class) continue;
                    symbol = "objc_msgSend";
                    break;
                }
            }
            if (symbol == null) continue;
            if (ObjCRuntime.isStret(method)) {
                symbol = symbol + "_stret";
            }
            long f = Runtime.resolveBridge((String)"objc", (String)symbol, (Method)method);
            VM.bindBridgeMethod((Method)method, (long)f);
        }
        Bro.bind(c);
    }

    static boolean isStret(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType.getSuperclass() == Struct.class && (method.getAnnotation(ByVal.class) != null || returnType.getAnnotation(ByVal.class) != null)) {
            int structSize = ObjCRuntime.getStructSize(returnType);
            if (Bro.IS_X86 && Bro.IS_32BIT) {
                if (structSize > 2 && structSize != 4 && structSize != 8) {
                    return true;
                }
            } else if (Bro.IS_X86 && Bro.IS_64BIT) {
                if (structSize > 16) {
                    return true;
                }
            } else if (Bro.IS_ARM && Bro.IS_32BIT) {
                if (structSize > 4) {
                    return true;
                }
            } else {
                if (Bro.IS_ARM && Bro.IS_64BIT) {
                    return false;
                }
                throw new Error("Unsupported architecture");
            }
        }
        return false;
    }

    static synchronized int getStructSize(Class<?> cls) {
        Integer size = structSizes.get(cls);
        if (size == null) {
            try {
                Method sizeOf = cls.getMethod("sizeOf", new Class[0]);
                size = (Integer)sizeOf.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new Error(e);
            }
            structSizes.put(cls, size);
        }
        return size;
    }

    @Bridge
    public static native BytePtr sel_getName(Selector var0);

    @Bridge
    public static native Selector sel_registerName(BytePtr var0);

    @Bridge
    @Pointer
    public static native long objc_getClass(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long objc_getMetaClass(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long objc_allocateClassPair(@Pointer long var0, @Pointer long var2, @Pointer long var4);

    @Bridge
    public static native void objc_registerClassPair(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long objc_getProtocol(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long objc_allocateProtocol(@Pointer long var0);

    @Bridge
    public static native void objc_registerProtocol(@Pointer long var0);

    @Bridge
    public static native void objc_setAssociatedObject(@Pointer long var0, @Pointer long var2, @Pointer long var4, int var6);

    @Bridge
    @Pointer
    public static native long objc_getAssociatedObject(@Pointer long var0, @Pointer long var2);

    @Bridge
    @Pointer
    public static native long objc_copyProtocolList(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long object_getClass(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long object_setClass(@Pointer long var0, @Pointer long var2);

    @Bridge
    @Pointer
    public static native long object_getClassName(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long object_dispose(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long object_getIvar(@Pointer long var0, @Pointer long var2);

    @Bridge
    public static native void object_setIvar(@Pointer long var0, @Pointer long var2, @Pointer long var4);

    @Bridge
    @Pointer
    public static native long class_getSuperclass(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long class_isMetaClass(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long class_getName(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long class_getInstanceMethod(@Pointer long var0, @Pointer long var2);

    @Bridge
    @Pointer
    public static native long class_getClassMethod(@Pointer long var0, @Pointer long var2);

    @Bridge
    public static native boolean class_addProtocol(@Pointer long var0, @Pointer long var2);

    @Bridge
    public static native boolean class_conformsToProtocol(@Pointer long var0, @Pointer long var2);

    @Bridge
    @Pointer
    public static native long class_copyProtocolList(@Pointer long var0, @Pointer long var2);

    @Bridge
    @Pointer
    public static native long class_copyMethodList(@Pointer long var0, @Pointer long var2);

    @Bridge
    @Pointer
    public static native long class_copyPropertyList(@Pointer long var0, @Pointer long var2);

    @Bridge
    public static native boolean class_addMethod(@Pointer long var0, @Pointer long var2, @Pointer long var4, @Pointer long var6);

    @Bridge
    @Pointer
    public static native long class_replaceMethod(@Pointer long var0, @Pointer long var2, @Pointer long var4, @Pointer long var6);

    @Bridge
    @Pointer
    public static native long class_getMethodImplementation(@Pointer long var0, @Pointer long var2);

    @Bridge
    public static native boolean class_addIvar(@Pointer long var0, @Pointer long var2, int var4, byte var5, @Pointer long var6);

    @Bridge
    @Pointer
    public static native long class_getInstanceVariable(@Pointer long var0, @Pointer long var2);

    @Bridge
    @Pointer
    public static native long class_getClassVariable(@Pointer long var0, @Pointer long var2);

    @Bridge
    @Pointer
    public static native long class_getIvarLayout(@Pointer long var0);

    @Bridge
    public static native void class_setIvarLayout(@Pointer long var0, @Pointer long var2);

    @Bridge
    @Pointer
    public static native long class_getProperty(@Pointer long var0, @Pointer long var2);

    @Bridge
    public static native boolean class_respondsToSelector(@Pointer long var0, @Pointer long var2);

    @Bridge
    @Pointer
    public static native long protocol_getName(@Pointer long var0);

    @Bridge
    public static native void protocol_addProtocol(@Pointer long var0, @Pointer long var2);

    @Bridge
    public static native boolean protocol_conformsToProtocol(@Pointer long var0, @Pointer long var2);

    @Bridge
    @Pointer
    public static native long protocol_getProperty(@Pointer long var0, @Pointer long var2, boolean var4, boolean var5);

    @Bridge
    @Pointer
    public static native long protocol_copyProtocolList(@Pointer long var0, @Pointer long var2);

    @Bridge
    @Pointer
    public static native long ivar_getName(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long ivar_getTypeEncoding(@Pointer long var0);

    @Bridge
    public static native int ivar_getOffset(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long method_getName(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long method_copyReturnType(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long method_copyArgumentType(@Pointer long var0, int var2);

    @Bridge
    public static native int method_getNumberOfArguments(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long method_getTypeEncoding(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long method_getImplementation(@Pointer long var0);

    @Bridge
    @Pointer
    public static native long method_setImplementation(@Pointer long var0, @Pointer long var2);

    @Bridge
    public static native void method_exchangeImplementations(@Pointer long var0, @Pointer long var2);

    @Bridge
    @Pointer
    public static native long property_getName(@Pointer long var0);

    @Bridge
    public static native BytePtr property_getAttributes(@Pointer long var0);

    @Bridge
    public static native BytePtr property_copyAttributeValue(@Pointer long var0, BytePtr var2);

    @Bridge(symbol="objc_msgSend")
    @Pointer
    public static native long ptr_objc_msgSend(@Pointer long var0, @Pointer long var2);

    @Bridge(symbol="objc_msgSendSuper")
    @Pointer
    public static native long ptr_objc_msgSendSuper(@Pointer long var0, @Pointer long var2);

    @Bridge(symbol="objc_msgSend")
    public static native void void_objc_msgSend(@Pointer long var0, @Pointer long var2);

    @Bridge(symbol="objc_msgSendSuper")
    public static native void void_objc_msgSendSuper(@Pointer long var0, @Pointer long var2);

    @Bridge(symbol="objc_msgSend")
    public static native boolean boolean_objc_msgSend(@Pointer long var0, @Pointer long var2);

    @Bridge(symbol="objc_msgSend")
    public static native void void_objc_msgSend_ptr(@Pointer long var0, @Pointer long var2, @Pointer long var4);

    @Bridge(symbol="objc_msgSend")
    public static native void void_objc_msgSend_boolean(@Pointer long var0, @Pointer long var2, boolean var4);

    @Bridge(symbol="objc_msgSend")
    public static native int int_objc_msgSend(@Pointer long var0, @Pointer long var2);

    @Bridge(symbol="objc_msgSend")
    @Pointer
    public static native long ptr_objc_msgSend_ptr(@Pointer long var0, @Pointer long var2, @Pointer long var4);

    @Bridge(symbol="objc_msgSend")
    @Pointer
    public static native long ptr_objc_msgSend_int(@Pointer long var0, @Pointer long var2, int var4);

    @Bridge(symbol="objc_msgSend")
    @Pointer
    public static native long ptr_objc_msgSend_long(@Pointer long var0, @Pointer long var2, long var4);

    @Bridge(symbol="objc_msgSend")
    public static native char char_objc_msgSend_int(@Pointer long var0, @Pointer long var2, int var4);

    @Bridge(symbol="objc_msgSend_stret", optional=true)
    public static native void objc_msgSend_stret(@StructRet @Pointer long var0, @Pointer long var2, @Pointer long var4);

    static {
        Bro.bind(ObjCRuntime.class);
    }
}

