package com.bugvm.bouncycastle.jcajce.provider.digest;

import com.bugvm.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.bugvm.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.bugvm.bouncycastle.crypto.CipherKeyGenerator;
import com.bugvm.bouncycastle.crypto.digests.SHA256Digest;
import com.bugvm.bouncycastle.crypto.macs.HMac;
import com.bugvm.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.bugvm.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.bugvm.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class SHA256
{
    private SHA256()
    {

    }

    static public class Digest
        extends BCMessageDigest
        implements Cloneable
    {
        public Digest()
        {
            super(new SHA256Digest());
        }

        public Object clone()
            throws CloneNotSupportedException
        {
            Digest d = (Digest)super.clone();
            d.digest = new SHA256Digest((SHA256Digest)digest);

            return d;
        }
    }

    public static class HashMac
        extends BaseMac
    {
        public HashMac()
        {
            super(new HMac(new SHA256Digest()));
        }
    }

    // BEGIN android-removed
    // /**
    //  * PBEWithHmacSHA
    //  */
    // public static class PBEWithMacKeyFactory
    //     extends PBESecretKeyFactory
    // {
    //     public PBEWithMacKeyFactory()
    //     {
    //         super("PBEwithHmacSHA256", null, false, PKCS12, SHA256, 256, 0);
    //     }
    // }
    // END android-removed

    /**
     * HMACSHA256
     */
    public static class KeyGenerator
        extends BaseKeyGenerator
    {
        public KeyGenerator()
        {
            super("HMACSHA256", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
        extends DigestAlgorithmProvider
    {
        private static final String PREFIX = SHA256.class.getName();

        public Mappings()
        {
        }

        public void configure(ConfigurableProvider provider)
        {
            provider.addAlgorithm("MessageDigest.SHA-256", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest.SHA256", "SHA-256");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha256, "SHA-256");

            // BEGIN android-removed
            // provider.addAlgorithm("SecretKeyFactory.PBEWITHHMACSHA256", PREFIX + "$PBEWithMacKeyFactory");
            // provider.addAlgorithm("Alg.Alias.SecretKeyFactory.PBEWITHHMACSHA-256", "PBEWITHHMACSHA256");
            // provider.addAlgorithm("Alg.Alias.SecretKeyFactory." + NISTObjectIdentifiers.id_sha256, "PBEWITHHMACSHA256");
            // END android-removed

            addHMACAlgorithm(provider, "SHA256", PREFIX + "$HashMac",  PREFIX + "$KeyGenerator");
            addHMACAlias(provider, "SHA256", PKCSObjectIdentifiers.id_hmacWithSHA256);
            addHMACAlias(provider, "SHA256", NISTObjectIdentifiers.id_sha256);
        }
    }
}
