package com.bugvm.bouncycastle.jcajce.provider.digest;

import com.bugvm.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.bugvm.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.bugvm.bouncycastle.crypto.CipherKeyGenerator;
import com.bugvm.bouncycastle.crypto.digests.SHA384Digest;
import com.bugvm.bouncycastle.crypto.macs.HMac;
// BEGIN android-removed
// import com.bugvm.bouncycastle.crypto.macs.OldHMac;
// END android-removed
import com.bugvm.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.bugvm.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.bugvm.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class SHA384
{
    private SHA384()
    {

    }

    static public class Digest
        extends BCMessageDigest
        implements Cloneable
    {
        public Digest()
        {
            super(new SHA384Digest());
        }

        public Object clone()
            throws CloneNotSupportedException
        {
            Digest d = (Digest)super.clone();
            d.digest = new SHA384Digest((SHA384Digest)digest);

            return d;
        }
    }

    public static class HashMac
        extends BaseMac
    {
        public HashMac()
        {
            super(new HMac(new SHA384Digest()));
        }
    }

    /**
     * HMACSHA384
     */
    public static class KeyGenerator
        extends BaseKeyGenerator
    {
        public KeyGenerator()
        {
            super("HMACSHA384", 384, new CipherKeyGenerator());
        }
    }

    // BEGIN android-removed
    // public static class OldSHA384
    //     extends BaseMac
    // {
    //     public OldSHA384()
    //     {
    //         super(new OldHMac(new SHA384Digest()));
    //     }
    // }
    // END android-removed

    public static class Mappings
        extends DigestAlgorithmProvider
    {
        private static final String PREFIX = SHA384.class.getName();

        public Mappings()
        {
        }

        public void configure(ConfigurableProvider provider)
        {
            provider.addAlgorithm("MessageDigest.SHA-384", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest.SHA384", "SHA-384");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha384, "SHA-384");
            // BEGIN android-removed
            // provider.addAlgorithm("Mac.OLDHMACSHA384", PREFIX + "$OldSHA384");
            // END android-removed

            addHMACAlgorithm(provider, "SHA384", PREFIX + "$HashMac",  PREFIX + "$KeyGenerator");
            addHMACAlias(provider, "SHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        }
    }
}
