/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.bouncycastle.asn1;

import com.bugvm.bouncycastle.asn1.BERGenerator;
import com.bugvm.bouncycastle.asn1.DEROctetString;
import com.bugvm.bouncycastle.asn1.DEROutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BEROctetStringGenerator
extends BERGenerator {
    public BEROctetStringGenerator(OutputStream out) throws IOException {
        super(out);
        this.writeBERHeader(36);
    }

    public BEROctetStringGenerator(OutputStream out, int tagNo, boolean isExplicit) throws IOException {
        super(out, tagNo, isExplicit);
        this.writeBERHeader(36);
    }

    public OutputStream getOctetOutputStream() {
        return this.getOctetOutputStream(new byte[1000]);
    }

    public OutputStream getOctetOutputStream(byte[] buf) {
        return new BufferedBEROctetStream(buf);
    }

    private class BufferedBEROctetStream
    extends OutputStream {
        private byte[] _buf;
        private int _off;
        private DEROutputStream _derOut;

        BufferedBEROctetStream(byte[] buf) {
            this._buf = buf;
            this._off = 0;
            this._derOut = new DEROutputStream(BEROctetStringGenerator.this._out);
        }

        @Override
        public void write(int b) throws IOException {
            this._buf[this._off++] = (byte)b;
            if (this._off == this._buf.length) {
                DEROctetString.encode(this._derOut, this._buf);
                this._off = 0;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            while (len > 0) {
                int numToCopy = Math.min(len, this._buf.length - this._off);
                System.arraycopy((Object)b, off, (Object)this._buf, this._off, numToCopy);
                this._off += numToCopy;
                if (this._off < this._buf.length) break;
                DEROctetString.encode(this._derOut, this._buf);
                this._off = 0;
                off += numToCopy;
                len -= numToCopy;
            }
        }

        @Override
        public void close() throws IOException {
            if (this._off != 0) {
                byte[] bytes = new byte[this._off];
                System.arraycopy((Object)this._buf, 0, (Object)bytes, 0, this._off);
                DEROctetString.encode(this._derOut, bytes);
            }
            BEROctetStringGenerator.this.writeBEREnd();
        }
    }
}

