/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.bouncycastle.asn1;

import com.bugvm.bouncycastle.asn1.ASN1Boolean;
import com.bugvm.bouncycastle.asn1.ASN1OctetString;
import com.bugvm.bouncycastle.asn1.ASN1OutputStream;
import com.bugvm.bouncycastle.asn1.ASN1Primitive;
import com.bugvm.bouncycastle.asn1.ASN1TaggedObject;
import com.bugvm.bouncycastle.util.Arrays;
import java.io.IOException;

public class DERBoolean
extends ASN1Primitive {
    private static final byte[] TRUE_VALUE = new byte[]{-1};
    private static final byte[] FALSE_VALUE = new byte[]{0};
    private final byte[] value;
    public static final ASN1Boolean FALSE = new ASN1Boolean(false);
    public static final ASN1Boolean TRUE = new ASN1Boolean(true);

    public static ASN1Boolean getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Boolean) {
            return (ASN1Boolean)obj;
        }
        if (obj instanceof DERBoolean) {
            return ((DERBoolean)obj).isTrue() ? TRUE : FALSE;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Boolean getInstance(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static ASN1Boolean getInstance(int value) {
        return value != 0 ? TRUE : FALSE;
    }

    public static DERBoolean getInstance(byte[] octets) {
        return octets[0] != 0 ? TRUE : FALSE;
    }

    public static ASN1Boolean getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERBoolean) {
            return DERBoolean.getInstance(o);
        }
        return ASN1Boolean.fromOctetString(((ASN1OctetString)o).getOctets());
    }

    protected DERBoolean(byte[] value) {
        if (value.length != 1) {
            throw new IllegalArgumentException("byte value should have 1 byte in it");
        }
        this.value = value[0] == 0 ? FALSE_VALUE : (value[0] == 255 ? TRUE_VALUE : Arrays.clone(value));
    }

    protected DERBoolean(boolean value) {
        this.value = value ? TRUE_VALUE : FALSE_VALUE;
    }

    public boolean isTrue() {
        return this.value[0] != 0;
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 3;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(1, this.value);
    }

    @Override
    protected boolean asn1Equals(ASN1Primitive o) {
        if (o == null || !(o instanceof DERBoolean)) {
            return false;
        }
        return this.value[0] == ((DERBoolean)o).value[0];
    }

    @Override
    public int hashCode() {
        return this.value[0];
    }

    public String toString() {
        return this.value[0] != 0 ? "TRUE" : "FALSE";
    }

    static ASN1Boolean fromOctetString(byte[] value) {
        if (value.length != 1) {
            throw new IllegalArgumentException("byte value should have 1 byte in it");
        }
        if (value[0] == 0) {
            return FALSE;
        }
        if (value[0] == 255) {
            return TRUE;
        }
        return new ASN1Boolean(value);
    }
}

