/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.bouncycastle.cms;

import com.bugvm.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.bugvm.bouncycastle.asn1.ASN1Set;
import com.bugvm.bouncycastle.asn1.DEROctetString;
import com.bugvm.bouncycastle.asn1.DERSet;
import com.bugvm.bouncycastle.asn1.cms.Attribute;
import com.bugvm.bouncycastle.asn1.cms.AttributeTable;
import com.bugvm.bouncycastle.asn1.cms.CMSAttributes;
import com.bugvm.bouncycastle.asn1.cms.Time;
import com.bugvm.bouncycastle.cms.CMSAttributeTableGenerator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

public class DefaultSignedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultSignedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultSignedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map parameters) {
        Attribute attr;
        ASN1ObjectIdentifier contentType;
        Hashtable std = (Hashtable)this.table.clone();
        if (!std.containsKey(CMSAttributes.contentType) && (contentType = ASN1ObjectIdentifier.getInstance(parameters.get("contentType"))) != null) {
            attr = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet(contentType));
            std.put(attr.getAttrType(), attr);
        }
        if (!std.containsKey(CMSAttributes.signingTime)) {
            Date signingTime = new Date();
            attr = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet(new Time(signingTime)));
            std.put(attr.getAttrType(), attr);
        }
        if (!std.containsKey(CMSAttributes.messageDigest)) {
            byte[] messageDigest = (byte[])parameters.get("digest");
            attr = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString(messageDigest)));
            std.put(attr.getAttrType(), attr);
        }
        return std;
    }

    @Override
    public AttributeTable getAttributes(Map parameters) {
        return new AttributeTable(this.createStandardAttributeTable(parameters));
    }
}

