/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.bouncycastle.crypto.agreement;

import com.bugvm.bouncycastle.crypto.BasicAgreement;
import com.bugvm.bouncycastle.crypto.CipherParameters;
import com.bugvm.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.bugvm.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.bugvm.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class ECDHBasicAgreement
implements BasicAgreement {
    private ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters key) {
        this.key = (ECPrivateKeyParameters)key;
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters pubKey) {
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pubKey;
        ECPoint P = pub.getQ().multiply(this.key.getD());
        return P.getX().toBigInteger();
    }
}

