/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.bouncycastle.crypto.digests;

import com.bugvm.bouncycastle.crypto.Digest;
import com.bugvm.bouncycastle.crypto.digests.AndroidDigestFactoryInterface;

public final class AndroidDigestFactory {
    private static final String OpenSSLFactoryClassName;
    private static final String BouncyCastleFactoryClassName;
    private static final AndroidDigestFactoryInterface FACTORY;

    public static Digest getMD5() {
        return FACTORY.getMD5();
    }

    public static Digest getSHA1() {
        return FACTORY.getSHA1();
    }

    public static Digest getSHA256() {
        return FACTORY.getSHA256();
    }

    public static Digest getSHA384() {
        return FACTORY.getSHA384();
    }

    public static Digest getSHA512() {
        return FACTORY.getSHA512();
    }

    static {
        Class<?> factoryImplementationClass;
        OpenSSLFactoryClassName = AndroidDigestFactory.class.getName() + "OpenSSL";
        BouncyCastleFactoryClassName = AndroidDigestFactory.class.getName() + "BouncyCastle";
        try {
            factoryImplementationClass = Class.forName(OpenSSLFactoryClassName);
            Class.forName("com.bugvm.conscrypt.NativeCrypto");
        }
        catch (ClassNotFoundException e1) {
            try {
                factoryImplementationClass = Class.forName(BouncyCastleFactoryClassName);
            }
            catch (ClassNotFoundException e2) {
                AssertionError e = new AssertionError((Object)("Failed to load AndroidDigestFactoryInterface implementation. Looked for " + OpenSSLFactoryClassName + " and " + BouncyCastleFactoryClassName));
                ((Throwable)((Object)e)).initCause(e1);
                throw e;
            }
        }
        if (!AndroidDigestFactoryInterface.class.isAssignableFrom(factoryImplementationClass)) {
            throw new AssertionError((Object)(factoryImplementationClass + "does not implement AndroidDigestFactoryInterface"));
        }
        try {
            FACTORY = (AndroidDigestFactoryInterface)factoryImplementationClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

