/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.bouncycastle.crypto.digests;

import com.bugvm.bouncycastle.crypto.Digest;
import java.io.ByteArrayOutputStream;

public class NullDigest
implements Digest {
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    @Override
    public String getAlgorithmName() {
        return "NULL";
    }

    @Override
    public int getDigestSize() {
        return this.bOut.size();
    }

    @Override
    public void update(byte in) {
        this.bOut.write(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.bOut.write(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        byte[] res = this.bOut.toByteArray();
        System.arraycopy((Object)res, 0, (Object)out, outOff, res.length);
        this.reset();
        return res.length;
    }

    @Override
    public void reset() {
        this.bOut.reset();
    }
}

