/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.bouncycastle.crypto.generators;

import com.bugvm.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.bugvm.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.bugvm.bouncycastle.crypto.KeyGenerationParameters;
import com.bugvm.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import com.bugvm.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.bugvm.bouncycastle.crypto.params.DHParameters;
import com.bugvm.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.bugvm.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

