/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.bouncycastle.crypto.generators;

import com.bugvm.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.bugvm.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.bugvm.bouncycastle.crypto.KeyGenerationParameters;
import com.bugvm.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import com.bugvm.bouncycastle.crypto.params.DSAParameters;
import com.bugvm.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.bugvm.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.bugvm.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dsaParams = this.param.getParameters();
        BigInteger x = DSAKeyPairGenerator.generatePrivateKey(dsaParams.getQ(), this.param.getRandom());
        BigInteger y = DSAKeyPairGenerator.calculatePublicKey(dsaParams.getP(), dsaParams.getG(), x);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y, dsaParams), new DSAPrivateKeyParameters(x, dsaParams));
    }

    private static BigInteger generatePrivateKey(BigInteger q, SecureRandom random) {
        return BigIntegers.createRandomInRange(ONE, q.subtract(ONE), random);
    }

    private static BigInteger calculatePublicKey(BigInteger p, BigInteger g, BigInteger x) {
        return g.modPow(x, p);
    }
}

