/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.bouncycastle.crypto.modes.gcm;

import com.bugvm.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import com.bugvm.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.bugvm.bouncycastle.util.Arrays;
import java.util.Vector;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    @Override
    public void init(byte[] x) {
        if (this.lookupPowX2 != null && Arrays.areEqual(x, (byte[])this.lookupPowX2.elementAt(0))) {
            return;
        }
        this.lookupPowX2 = new Vector(8);
        this.lookupPowX2.addElement(Arrays.clone(x));
    }

    @Override
    public void exponentiateX(long pow, byte[] output) {
        byte[] y = GCMUtil.oneAsBytes();
        int bit = 0;
        while (pow > 0L) {
            if ((pow & 1L) != 0L) {
                this.ensureAvailable(bit);
                GCMUtil.multiply(y, (byte[])this.lookupPowX2.elementAt(bit));
            }
            ++bit;
            pow >>>= 1;
        }
        System.arraycopy((Object)y, 0, (Object)output, 0, 16);
    }

    private void ensureAvailable(int bit) {
        int count = this.lookupPowX2.size();
        if (count <= bit) {
            byte[] tmp = (byte[])this.lookupPowX2.elementAt(count - 1);
            do {
                tmp = Arrays.clone(tmp);
                GCMUtil.multiply(tmp, tmp);
                this.lookupPowX2.addElement(tmp);
            } while (++count <= bit);
        }
    }
}

