/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.conscrypt;

import com.bugvm.conscrypt.HandshakeIODataStream;
import com.bugvm.conscrypt.Message;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class CertificateMessage
extends Message {
    X509Certificate[] certs;
    byte[][] encoded_certs;

    public CertificateMessage(HandshakeIODataStream in, int length) throws IOException {
        CertificateFactory cf;
        int l = in.readUint24();
        if (l == 0) {
            if (length != 3) {
                this.fatalAlert((byte)50, "DECODE ERROR: incorrect CertificateMessage");
            }
            this.certs = new X509Certificate[0];
            this.encoded_certs = new byte[0][0];
            this.length = 3;
            return;
        }
        try {
            cf = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException e) {
            this.fatalAlert((byte)80, "INTERNAL ERROR", e);
            return;
        }
        ArrayList<X509Certificate> certsList = new ArrayList<X509Certificate>();
        int size = 0;
        int enc_size = 0;
        while (l > 0) {
            size = in.readUint24();
            l -= 3;
            try {
                certsList.add((X509Certificate)cf.generateCertificate(in));
            }
            catch (CertificateException e) {
                this.fatalAlert((byte)50, "DECODE ERROR", e);
            }
            l -= size;
            enc_size += size;
        }
        this.certs = certsList.toArray(new X509Certificate[certsList.size()]);
        this.length = 3 + 3 * this.certs.length + enc_size;
        if (this.length != length) {
            this.fatalAlert((byte)50, "DECODE ERROR: incorrect CertificateMessage");
        }
    }

    public CertificateMessage(X509Certificate[] certs) {
        int i;
        if (certs == null) {
            this.certs = new X509Certificate[0];
            this.encoded_certs = new byte[0][0];
            this.length = 3;
            return;
        }
        this.certs = certs;
        if (this.encoded_certs == null) {
            this.encoded_certs = new byte[certs.length][];
            for (i = 0; i < certs.length; ++i) {
                try {
                    this.encoded_certs[i] = certs[i].getEncoded();
                    continue;
                }
                catch (CertificateEncodingException e) {
                    this.fatalAlert((byte)80, "INTERNAL ERROR", e);
                }
            }
        }
        this.length = 3 + 3 * this.encoded_certs.length;
        for (i = 0; i < this.encoded_certs.length; ++i) {
            this.length += this.encoded_certs[i].length;
        }
    }

    @Override
    public void send(HandshakeIODataStream out) {
        int i;
        int total_length = 0;
        if (this.encoded_certs == null) {
            this.encoded_certs = new byte[this.certs.length][];
            for (i = 0; i < this.certs.length; ++i) {
                try {
                    this.encoded_certs[i] = this.certs[i].getEncoded();
                    continue;
                }
                catch (CertificateEncodingException e) {
                    this.fatalAlert((byte)80, "INTERNAL ERROR", e);
                }
            }
        }
        total_length = 3 * this.encoded_certs.length;
        for (i = 0; i < this.encoded_certs.length; ++i) {
            total_length += this.encoded_certs[i].length;
        }
        out.writeUint24(total_length);
        for (i = 0; i < this.encoded_certs.length; ++i) {
            out.writeUint24(this.encoded_certs[i].length);
            out.write(this.encoded_certs[i]);
        }
    }

    public String getAuthType() {
        return this.certs[0].getPublicKey().getAlgorithm();
    }

    @Override
    public int getType() {
        return 11;
    }
}

