/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.conscrypt;

import com.bugvm.conscrypt.CipherSuite;
import com.bugvm.conscrypt.HandshakeIODataStream;
import com.bugvm.conscrypt.Message;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import libcore.io.Streams;

public class CertificateRequest
extends Message {
    final byte[] certificate_types;
    final X500Principal[] certificate_authorities;
    private String[] types;
    private byte[][] encoded_principals;

    public CertificateRequest(byte[] certificate_types, X509Certificate[] accepted) {
        if (accepted == null) {
            this.fatalAlert((byte)80, "CertificateRequest: array of certificate authority certificates is null");
        }
        this.certificate_types = certificate_types;
        int totalPrincipalsLength = 0;
        this.certificate_authorities = new X500Principal[accepted.length];
        this.encoded_principals = new byte[accepted.length][];
        for (int i = 0; i < accepted.length; ++i) {
            this.certificate_authorities[i] = accepted[i].getIssuerX500Principal();
            this.encoded_principals[i] = this.certificate_authorities[i].getEncoded();
            totalPrincipalsLength += this.encoded_principals[i].length + 2;
        }
        this.length = 3 + certificate_types.length + totalPrincipalsLength;
    }

    public CertificateRequest(HandshakeIODataStream in, int length) throws IOException {
        int totalPrincipalsLength;
        int size = in.readUint8();
        this.certificate_types = new byte[size];
        Streams.readFully(in, this.certificate_types);
        size = in.readUint16();
        int principalLength = 0;
        ArrayList<X500Principal> principals = new ArrayList<X500Principal>();
        for (totalPrincipalsLength = 0; totalPrincipalsLength < size; totalPrincipalsLength += principalLength) {
            principalLength = in.readUint16();
            principals.add(new X500Principal(in));
            totalPrincipalsLength += 2;
        }
        this.certificate_authorities = principals.toArray(new X500Principal[principals.size()]);
        this.length = 3 + this.certificate_types.length + totalPrincipalsLength;
        if (this.length != length) {
            this.fatalAlert((byte)50, "DECODE ERROR: incorrect CertificateRequest");
        }
    }

    @Override
    public void send(HandshakeIODataStream out) {
        int i;
        out.writeUint8(this.certificate_types.length);
        for (int i2 = 0; i2 < this.certificate_types.length; ++i2) {
            out.write(this.certificate_types[i2]);
        }
        int authoritiesLength = 0;
        for (i = 0; i < this.certificate_authorities.length; ++i) {
            authoritiesLength += this.encoded_principals[i].length + 2;
        }
        out.writeUint16(authoritiesLength);
        for (i = 0; i < this.certificate_authorities.length; ++i) {
            out.writeUint16(this.encoded_principals[i].length);
            out.write(this.encoded_principals[i]);
        }
    }

    @Override
    public int getType() {
        return 13;
    }

    public String[] getTypesAsString() {
        if (this.types == null) {
            this.types = new String[this.certificate_types.length];
            for (int i = 0; i < this.types.length; ++i) {
                String type = CipherSuite.getClientKeyType(this.certificate_types[i]);
                if (type == null) {
                    this.fatalAlert((byte)50, "DECODE ERROR: incorrect CertificateRequest");
                }
                this.types[i] = type;
            }
        }
        return this.types;
    }
}

