/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.conscrypt;

import com.bugvm.conscrypt.NativeCrypto;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class OpenSSLMessageDigestJDK
extends MessageDigest
implements Cloneable {
    private long ctx;
    private final long evp_md;
    private final int size;
    private final byte[] singleByte = new byte[1];

    private OpenSSLMessageDigestJDK(String algorithm, long evp_md, int size) throws NoSuchAlgorithmException {
        super(algorithm);
        this.evp_md = evp_md;
        this.size = size;
    }

    @Override
    protected void engineReset() {
        this.free();
    }

    @Override
    protected int engineGetDigestLength() {
        return this.size;
    }

    @Override
    protected void engineUpdate(byte input) {
        this.singleByte[0] = input;
        this.engineUpdate(this.singleByte, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        NativeCrypto.EVP_DigestUpdate(this.getCtx(), input, offset, len);
    }

    @Override
    protected byte[] engineDigest() {
        byte[] result = new byte[this.size];
        NativeCrypto.EVP_DigestFinal(this.getCtx(), result, 0);
        this.ctx = 0L;
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OpenSSLMessageDigestJDK d = (OpenSSLMessageDigestJDK)super.clone();
        d.ctx = NativeCrypto.EVP_MD_CTX_copy(this.getCtx());
        return d;
    }

    private long getCtx() {
        if (this.ctx == 0L) {
            this.ctx = NativeCrypto.EVP_DigestInit(this.evp_md);
        }
        return this.ctx;
    }

    private void free() {
        if (this.ctx != 0L) {
            NativeCrypto.EVP_MD_CTX_destroy(this.ctx);
            this.ctx = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.free();
        }
        finally {
            super.finalize();
        }
    }

    public static class SHA512
    extends OpenSSLMessageDigestJDK {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha512");
        private static final int SIZE = NativeCrypto.EVP_MD_size(EVP_MD);

        public SHA512() throws NoSuchAlgorithmException {
            super("SHA-512", EVP_MD, SIZE);
        }
    }

    public static class SHA384
    extends OpenSSLMessageDigestJDK {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha384");
        private static final int SIZE = NativeCrypto.EVP_MD_size(EVP_MD);

        public SHA384() throws NoSuchAlgorithmException {
            super("SHA-384", EVP_MD, SIZE);
        }
    }

    public static class SHA256
    extends OpenSSLMessageDigestJDK {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha256");
        private static final int SIZE = NativeCrypto.EVP_MD_size(EVP_MD);

        public SHA256() throws NoSuchAlgorithmException {
            super("SHA-256", EVP_MD, SIZE);
        }
    }

    public static class SHA1
    extends OpenSSLMessageDigestJDK {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha1");
        private static final int SIZE = NativeCrypto.EVP_MD_size(EVP_MD);

        public SHA1() throws NoSuchAlgorithmException {
            super("SHA-1", EVP_MD, SIZE);
        }
    }

    public static class MD5
    extends OpenSSLMessageDigestJDK {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("md5");
        private static final int SIZE = NativeCrypto.EVP_MD_size(EVP_MD);

        public MD5() throws NoSuchAlgorithmException {
            super("MD5", EVP_MD, SIZE);
        }
    }
}

