/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.conscrypt;

import com.bugvm.conscrypt.CipherSuite;
import com.bugvm.conscrypt.NativeCrypto;
import com.bugvm.conscrypt.OpenSSLSocketImpl;
import com.bugvm.conscrypt.SSLParametersImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;

public class OpenSSLServerSocketImpl
extends SSLServerSocket {
    private final SSLParametersImpl sslParameters;
    private String[] enabledProtocols = NativeCrypto.getSupportedProtocols();
    private String[] enabledCipherSuites = NativeCrypto.getDefaultCipherSuites();
    private boolean channelIdEnabled;

    protected OpenSSLServerSocketImpl(SSLParametersImpl sslParameters) throws IOException {
        this.sslParameters = sslParameters;
    }

    protected OpenSSLServerSocketImpl(int port, SSLParametersImpl sslParameters) throws IOException {
        super(port);
        this.sslParameters = sslParameters;
    }

    protected OpenSSLServerSocketImpl(int port, int backlog, SSLParametersImpl sslParameters) throws IOException {
        super(port, backlog);
        this.sslParameters = sslParameters;
    }

    protected OpenSSLServerSocketImpl(int port, int backlog, InetAddress iAddress, SSLParametersImpl sslParameters) throws IOException {
        super(port, backlog, iAddress);
        this.sslParameters = sslParameters;
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.sslParameters.setEnableSessionCreation(flag);
    }

    @Override
    public String[] getSupportedProtocols() {
        return NativeCrypto.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return (String[])this.enabledProtocols.clone();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = NativeCrypto.checkEnabledProtocols(protocols);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return NativeCrypto.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return (String[])this.enabledCipherSuites.clone();
    }

    public void setChannelIdEnabled(boolean enabled) {
        this.channelIdEnabled = enabled;
    }

    public boolean isChannelIdEnabled() {
        return this.channelIdEnabled;
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.enabledCipherSuites = NativeCrypto.checkEnabledCipherSuites(suites);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.sslParameters.setUseClientMode(mode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    @Override
    public Socket accept() throws IOException {
        if (!this.sslParameters.getUseClientMode()) {
            this.checkEnabledCipherSuites();
        }
        OpenSSLSocketImpl socket = new OpenSSLSocketImpl(this.sslParameters, (String[])this.enabledProtocols.clone(), (String[])this.enabledCipherSuites.clone());
        socket.setChannelIdEnabled(this.channelIdEnabled);
        this.implAccept(socket);
        return socket;
    }

    private void checkEnabledCipherSuites() throws SSLException {
        for (String enabledCipherSuite : this.enabledCipherSuites) {
            if (enabledCipherSuite.equals("TLS_EMPTY_RENEGOTIATION_INFO_SCSV")) continue;
            String keyType = CipherSuite.getByName(enabledCipherSuite).getServerKeyType();
            if (keyType == null) {
                return;
            }
            if (keyType.equals("RSA") || keyType.equals("DH_RSA")) {
                if (!this.checkForPrivateKey(keyType, RSAPrivateKey.class)) continue;
                return;
            }
            if (keyType.equals("DSA") || keyType.equals("DH_DSA")) {
                if (!this.checkForPrivateKey(keyType, DSAPrivateKey.class)) continue;
                return;
            }
            if (keyType.equals("EC") || keyType.equals("EC_RSA") || keyType.equals("EC_EC")) {
                if (!this.checkForPrivateKey(keyType, ECPrivateKey.class)) continue;
                return;
            }
            throw new IllegalStateException("Unknown key type " + keyType);
        }
        throw new SSLException("Could not find any key store entries to support the enabled cipher suites.");
    }

    private boolean checkForPrivateKey(String keyType, Class<?> keyClass) {
        String alias = this.sslParameters.getKeyManager().chooseServerAlias(keyType, null, null);
        if (alias == null) {
            return false;
        }
        PrivateKey key = this.sslParameters.getKeyManager().getPrivateKey(alias);
        return key != null && keyClass.isAssignableFrom(key.getClass());
    }
}

