/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.conscrypt;

import java.util.Hashtable;

public class ProtocolVersion {
    public static final String[] supportedProtocols = new String[]{"TLSv1", "SSLv3"};
    private static Hashtable<String, ProtocolVersion> protocolsByName = new Hashtable(4);
    public static final ProtocolVersion SSLv3 = new ProtocolVersion("SSLv3", new byte[]{3, 0});
    public static final ProtocolVersion TLSv1 = new ProtocolVersion("TLSv1", new byte[]{3, 1});
    public final String name;
    public final byte[] version;

    public static boolean isSupported(byte[] version) {
        return version[0] == 3 && (version[1] == 0 || version[1] == 1);
    }

    public static ProtocolVersion getByVersion(byte[] version) {
        if (version[0] == 3) {
            if (version[1] == 1) {
                return TLSv1;
            }
            if (version[1] == 0) {
                return SSLv3;
            }
        }
        return null;
    }

    public static boolean isSupported(String name) {
        return protocolsByName.containsKey(name);
    }

    public static ProtocolVersion getByName(String name) {
        return protocolsByName.get(name);
    }

    public static ProtocolVersion getLatestVersion(String[] protocols) {
        if (protocols == null || protocols.length == 0) {
            return null;
        }
        ProtocolVersion latest = ProtocolVersion.getByName(protocols[0]);
        for (int i = 1; i < protocols.length; ++i) {
            ProtocolVersion current = ProtocolVersion.getByName(protocols[i]);
            if (current == null || latest != null && latest.version[0] >= current.version[0] && (latest.version[0] != current.version[0] || latest.version[1] >= current.version[1])) continue;
            latest = current;
        }
        return latest;
    }

    private ProtocolVersion(String name, byte[] version) {
        this.name = name;
        this.version = version;
    }

    static {
        protocolsByName.put(ProtocolVersion.SSLv3.name, SSLv3);
        protocolsByName.put(ProtocolVersion.TLSv1.name, TLSv1);
        protocolsByName.put("SSL", SSLv3);
        protocolsByName.put("TLS", TLSv1);
    }
}

