/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.conscrypt;

import com.bugvm.conscrypt.CipherSuite;
import com.bugvm.conscrypt.SSLParametersImpl;
import com.bugvm.conscrypt.SSLSocketImpl;
import com.bugvm.conscrypt.SSLSocketWrapper;
import com.bugvm.conscrypt.util.EmptyArray;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import javax.net.ssl.SSLSocketFactory;

public class SSLSocketFactoryImpl
extends SSLSocketFactory {
    private final SSLParametersImpl sslParameters;
    private final IOException instantiationException;

    public SSLSocketFactoryImpl() {
        SSLParametersImpl sslParametersLocal = null;
        IOException instantiationExceptionLocal = null;
        try {
            sslParametersLocal = SSLParametersImpl.getDefault();
        }
        catch (KeyManagementException e) {
            instantiationExceptionLocal = new IOException("Delayed instantiation exception:");
            instantiationExceptionLocal.initCause(e);
        }
        this.sslParameters = sslParametersLocal;
        this.instantiationException = instantiationExceptionLocal;
    }

    protected SSLSocketFactoryImpl(SSLParametersImpl sslParameters) {
        this.sslParameters = sslParameters;
        this.instantiationException = null;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        if (this.instantiationException != null) {
            return EmptyArray.STRING;
        }
        return this.sslParameters.getEnabledCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        if (this.instantiationException != null) {
            return EmptyArray.STRING;
        }
        return CipherSuite.getSupportedCipherSuiteNames();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLSocketWrapper(s, host, port, autoClose, (SSLParametersImpl)this.sslParameters.clone());
    }

    @Override
    public Socket createSocket() throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLSocketImpl((SSLParametersImpl)this.sslParameters.clone());
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLSocketImpl(host, port, (SSLParametersImpl)this.sslParameters.clone());
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLSocketImpl(host, port, localHost, localPort, (SSLParametersImpl)this.sslParameters.clone());
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLSocketImpl(host, port, (SSLParametersImpl)this.sslParameters.clone());
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLSocketImpl(address, port, localAddress, localPort, (SSLParametersImpl)this.sslParameters.clone());
    }
}

