/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.conscrypt;

import com.bugvm.conscrypt.CipherSuite;
import com.bugvm.conscrypt.HandshakeIODataStream;
import com.bugvm.conscrypt.Message;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Date;
import libcore.io.Streams;

public class ServerHello
extends Message {
    byte[] server_version = new byte[2];
    byte[] random = new byte[32];
    byte[] session_id;
    CipherSuite cipher_suite;
    byte compression_method;

    public ServerHello(SecureRandom sr, byte[] server_version, byte[] session_id, CipherSuite cipher_suite, byte compression_method) {
        long gmt_unix_time = new Date().getTime() / 1000L;
        sr.nextBytes(this.random);
        this.random[0] = (byte)((gmt_unix_time & 0xFFFFFFFFFF000000L) >>> 24);
        this.random[1] = (byte)((gmt_unix_time & 0xFF0000L) >>> 16);
        this.random[2] = (byte)((gmt_unix_time & 0xFF00L) >>> 8);
        this.random[3] = (byte)(gmt_unix_time & 0xFFL);
        this.session_id = session_id;
        this.cipher_suite = cipher_suite;
        this.compression_method = compression_method;
        this.server_version = server_version;
        this.length = 38 + session_id.length;
    }

    public ServerHello(HandshakeIODataStream in, int length) throws IOException {
        this.server_version[0] = (byte)in.read();
        this.server_version[1] = (byte)in.read();
        Streams.readFully(in, this.random);
        int size = in.readUint8();
        this.session_id = new byte[size];
        in.read(this.session_id, 0, size);
        byte b0 = (byte)in.read();
        byte b1 = (byte)in.read();
        this.cipher_suite = CipherSuite.getByCode(b0, b1);
        this.compression_method = (byte)in.read();
        this.length = 38 + this.session_id.length;
        if (this.length != length) {
            this.fatalAlert((byte)50, "DECODE ERROR: incorrect ServerHello");
        }
    }

    @Override
    public void send(HandshakeIODataStream out) {
        out.write(this.server_version);
        out.write(this.random);
        out.writeUint8(this.session_id.length);
        out.write(this.session_id);
        out.write(this.cipher_suite.toBytes());
        out.write(this.compression_method);
        this.length = 38 + this.session_id.length;
    }

    public byte[] getRandom() {
        return this.random;
    }

    @Override
    public int getType() {
        return 2;
    }
}

