/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.conscrypt;

import com.bugvm.conscrypt.TrustManagerImpl;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;

public class TrustManagerFactoryImpl
extends TrustManagerFactorySpi {
    private KeyStore keyStore;

    @Override
    public void engineInit(KeyStore ks) throws KeyStoreException {
        if (ks != null) {
            this.keyStore = ks;
        } else {
            this.keyStore = KeyStore.getInstance("AndroidCAStore");
            try {
                this.keyStore.load(null, null);
            }
            catch (IOException e) {
                throw new KeyStoreException(e);
            }
            catch (CertificateException e) {
                throw new KeyStoreException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreException(e);
            }
        }
    }

    @Override
    public void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("ManagerFactoryParameters not supported");
    }

    @Override
    public TrustManager[] engineGetTrustManagers() {
        if (this.keyStore == null) {
            throw new IllegalStateException("TrustManagerFactory is not initialized");
        }
        return new TrustManager[]{new TrustManagerImpl(this.keyStore)};
    }
}

