/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.eaio.util;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class SafeFileName {
    private final Collection<String> reserved = Arrays.asList("aux", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "con", "nul", "prn", ".", "..");

    public String makeSafe(String in, String def) {
        String work = StringUtils.trimToNull((String)in);
        if (work == null) {
            return def;
        }
        StringBuilder builder = new StringBuilder(work.length());
        int i = 0;
        while (i < Math.min(255, work.length())) {
            char c = work.charAt(i);
            if (c > '\u001f') {
                switch (c) {
                    case '\"': 
                    case '%': 
                    case '*': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '\\': 
                    case '^': 
                    case '|': {
                        break;
                    }
                    case '-': {
                        if (builder.length() == 0) break;
                    }
                    case ' ': 
                    case '.': {
                        if (builder.length() == 0 || i == work.length() - 1 || i == 254) break;
                    }
                    default: {
                        builder.append(c);
                    }
                }
            }
            ++i;
        }
        if (builder.length() == 0) {
            return def;
        }
        String out = builder.toString();
        String outLower = out.toLowerCase();
        for (String r : this.reserved) {
            if (!outLower.startsWith(r)) continue;
            return def;
        }
        return out;
    }
}

