/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.eaio.util.text;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumanTime
implements Externalizable,
Comparable<HumanTime>,
Cloneable {
    private static final long serialVersionUID = 5179328390732826722L;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long YEAR = 31536000000L;
    private static final int CEILING_PERCENTAGE = 15;
    private long delta;

    static State getState(char c) {
        State out;
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                out = State.NUMBER;
                break;
            }
            case 'D': 
            case 'H': 
            case 'M': 
            case 'S': 
            case 'Y': 
            case 'd': 
            case 'h': 
            case 'm': 
            case 's': 
            case 'y': {
                out = State.UNIT;
                break;
            }
            default: {
                out = State.IGNORED;
            }
        }
        return out;
    }

    public static HumanTime eval(final CharSequence s) {
        HumanTime out = new HumanTime(0L);
        int num = 0;
        int start = 0;
        int end = 0;
        State oldState = State.IGNORED;
        for (char c : new Iterable<Character>(){

            @Override
            public Iterator<Character> iterator() {
                return new Iterator<Character>(){
                    private int p = 0;

                    @Override
                    public boolean hasNext() {
                        return this.p < s.length();
                    }

                    @Override
                    public Character next() {
                        return Character.valueOf(s.charAt(this.p++));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }) {
            State newState = HumanTime.getState(c);
            if (oldState != newState) {
                if (oldState == State.NUMBER && (newState == State.IGNORED || newState == State.UNIT)) {
                    num = Integer.parseInt(s.subSequence(start, end).toString());
                } else if (oldState == State.UNIT && (newState == State.IGNORED || newState == State.NUMBER)) {
                    out.nTimes(s.subSequence(start, end).toString(), num);
                    num = 0;
                }
                start = end;
            }
            ++end;
            oldState = newState;
        }
        if (oldState == State.UNIT) {
            out.nTimes(s.subSequence(start, end).toString(), num);
        }
        return out;
    }

    public static String exactly(CharSequence in) {
        return HumanTime.eval(in).getExactly();
    }

    public static String exactly(long l) {
        return new HumanTime(l).getExactly();
    }

    public static String approximately(CharSequence in) {
        return HumanTime.eval(in).getApproximately();
    }

    public static String approximately(long l) {
        return new HumanTime(l).getApproximately();
    }

    public HumanTime() {
        this(0L);
    }

    public HumanTime(long delta) {
        this.delta = Math.abs(delta);
    }

    private void nTimes(String unit, int n) {
        if ("ms".equalsIgnoreCase(unit)) {
            this.ms(n);
        } else if ("s".equalsIgnoreCase(unit)) {
            this.s(n);
        } else if ("m".equalsIgnoreCase(unit)) {
            this.m(n);
        } else if ("h".equalsIgnoreCase(unit)) {
            this.h(n);
        } else if ("d".equalsIgnoreCase(unit)) {
            this.d(n);
        } else if ("y".equalsIgnoreCase(unit)) {
            this.y(n);
        }
    }

    private long upperCeiling(long x) {
        return x / 100L * 85L;
    }

    private long lowerCeiling(long x) {
        return x / 100L * 15L;
    }

    private String ceil(long d, long n) {
        return Integer.toString((int)Math.ceil((double)d / (double)n));
    }

    private String floor(long d, long n) {
        return Integer.toString((int)Math.floor((double)d / (double)n));
    }

    public HumanTime y() {
        return this.y(1);
    }

    public HumanTime y(int n) {
        this.delta += 31536000000L * (long)Math.abs(n);
        return this;
    }

    public HumanTime d() {
        return this.d(1);
    }

    public HumanTime d(int n) {
        this.delta += 86400000L * (long)Math.abs(n);
        return this;
    }

    public HumanTime h() {
        return this.h(1);
    }

    public HumanTime h(int n) {
        this.delta += 3600000L * (long)Math.abs(n);
        return this;
    }

    public HumanTime m() {
        return this.m(1);
    }

    public HumanTime m(int n) {
        this.delta += 60000L * (long)Math.abs(n);
        return this;
    }

    public HumanTime s() {
        return this.s(1);
    }

    public HumanTime s(int n) {
        this.delta += 1000L * (long)Math.abs(n);
        return this;
    }

    public HumanTime ms() {
        return this.ms(1);
    }

    public HumanTime ms(int n) {
        this.delta += (long)Math.abs(n);
        return this;
    }

    public String getExactly() {
        return this.getExactly(new StringBuilder()).toString();
    }

    public <T extends Appendable> T getExactly(T a) {
        try {
            boolean prependBlank = false;
            long d = this.delta;
            if (d >= 31536000000L) {
                a.append(this.floor(d, 31536000000L));
                a.append(' ');
                a.append('y');
                prependBlank = true;
            }
            if ((d %= 31536000000L) >= 86400000L) {
                if (prependBlank) {
                    a.append(' ');
                }
                a.append(this.floor(d, 86400000L));
                a.append(' ');
                a.append('d');
                prependBlank = true;
            }
            if ((d %= 86400000L) >= 3600000L) {
                if (prependBlank) {
                    a.append(' ');
                }
                a.append(this.floor(d, 3600000L));
                a.append(' ');
                a.append('h');
                prependBlank = true;
            }
            if ((d %= 3600000L) >= 60000L) {
                if (prependBlank) {
                    a.append(' ');
                }
                a.append(this.floor(d, 60000L));
                a.append(' ');
                a.append('m');
                prependBlank = true;
            }
            if ((d %= 60000L) >= 1000L) {
                if (prependBlank) {
                    a.append(' ');
                }
                a.append(this.floor(d, 1000L));
                a.append(' ');
                a.append('s');
                prependBlank = true;
            }
            if ((d %= 1000L) > 0L) {
                if (prependBlank) {
                    a.append(' ');
                }
                a.append(Integer.toString((int)d));
                a.append(' ');
                a.append('m');
                a.append('s');
            }
        }
        catch (IOException iOException) {}
        return a;
    }

    public String getApproximately() {
        return this.getApproximately(new StringBuilder()).toString();
    }

    public <T extends Appendable> T getApproximately(T a) {
        try {
            int parts = 0;
            boolean rounded = false;
            boolean prependBlank = false;
            long d = this.delta;
            long mod = d % 31536000000L;
            if (mod >= this.upperCeiling(31536000000L)) {
                a.append(this.ceil(d, 31536000000L));
                a.append(' ');
                a.append('y');
                ++parts;
                rounded = true;
                prependBlank = true;
            } else if (d >= 31536000000L) {
                a.append(this.floor(d, 31536000000L));
                a.append(' ');
                a.append('y');
                ++parts;
                rounded = mod <= this.lowerCeiling(31536000000L);
                prependBlank = true;
            }
            if (!rounded) {
                mod = (d %= 31536000000L) % 86400000L;
                if (mod >= this.upperCeiling(86400000L)) {
                    if (prependBlank) {
                        a.append(' ');
                    }
                    a.append(this.ceil(d, 86400000L));
                    a.append(' ');
                    a.append('d');
                    ++parts;
                    rounded = true;
                    prependBlank = true;
                } else if (d >= 86400000L) {
                    if (prependBlank) {
                        a.append(' ');
                    }
                    a.append(this.floor(d, 86400000L));
                    a.append(' ');
                    a.append('d');
                    ++parts;
                    rounded = mod <= this.lowerCeiling(86400000L);
                    prependBlank = true;
                }
                if (parts < 2) {
                    mod = (d %= 86400000L) % 3600000L;
                    if (mod >= this.upperCeiling(3600000L)) {
                        if (prependBlank) {
                            a.append(' ');
                        }
                        a.append(this.ceil(d, 3600000L));
                        a.append(' ');
                        a.append('h');
                        ++parts;
                        rounded = true;
                        prependBlank = true;
                    } else if (d >= 3600000L && !rounded) {
                        if (prependBlank) {
                            a.append(' ');
                        }
                        a.append(this.floor(d, 3600000L));
                        a.append(' ');
                        a.append('h');
                        ++parts;
                        rounded = mod <= this.lowerCeiling(3600000L);
                        prependBlank = true;
                    }
                    if (parts < 2) {
                        mod = (d %= 3600000L) % 60000L;
                        if (mod >= this.upperCeiling(60000L)) {
                            if (prependBlank) {
                                a.append(' ');
                            }
                            a.append(this.ceil(d, 60000L));
                            a.append(' ');
                            a.append('m');
                            ++parts;
                            rounded = true;
                            prependBlank = true;
                        } else if (d >= 60000L && !rounded) {
                            if (prependBlank) {
                                a.append(' ');
                            }
                            a.append(this.floor(d, 60000L));
                            a.append(' ');
                            a.append('m');
                            ++parts;
                            rounded = mod <= this.lowerCeiling(60000L);
                            prependBlank = true;
                        }
                        if (parts < 2) {
                            mod = (d %= 60000L) % 1000L;
                            if (mod >= this.upperCeiling(1000L)) {
                                if (prependBlank) {
                                    a.append(' ');
                                }
                                a.append(this.ceil(d, 1000L));
                                a.append(' ');
                                a.append('s');
                                ++parts;
                                rounded = true;
                                prependBlank = true;
                            } else if (d >= 1000L && !rounded) {
                                if (prependBlank) {
                                    a.append(' ');
                                }
                                a.append(this.floor(d, 1000L));
                                a.append(' ');
                                a.append('s');
                                ++parts;
                                rounded = mod <= this.lowerCeiling(1000L);
                                prependBlank = true;
                            }
                            if (parts < 2 && (d %= 1000L) > 0L && !rounded) {
                                if (prependBlank) {
                                    a.append(' ');
                                }
                                a.append(Integer.toString((int)d));
                                a.append(' ');
                                a.append('m');
                                a.append('s');
                            }
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {}
        return a;
    }

    public long getDelta() {
        return this.delta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HumanTime)) {
            return false;
        }
        return this.delta == ((HumanTime)obj).delta;
    }

    public int hashCode() {
        return (int)(this.delta ^ this.delta >> 32);
    }

    public String toString() {
        return this.getExactly();
    }

    @Override
    public int compareTo(HumanTime t) {
        return this.delta == t.delta ? 0 : (this.delta < t.delta ? -1 : 1);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.delta = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.delta);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        NUMBER,
        IGNORED,
        UNIT;

    }
}

