/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.markdown;

import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CharacterProtector {
    private final ConcurrentMap<String, String> protectMap = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> unprotectMap = new ConcurrentHashMap<String, String>();
    private static final String GOOD_CHARS = "0123456789qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
    private Random rnd = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode(String literal) {
        String encoded = (String)this.protectMap.get(literal);
        if (encoded == null) {
            ConcurrentMap<String, String> concurrentMap = this.protectMap;
            synchronized (concurrentMap) {
                encoded = (String)this.protectMap.get(literal);
                if (encoded == null) {
                    encoded = this.addToken(literal);
                }
            }
        }
        return encoded;
    }

    public String decode(String coded) {
        return (String)this.unprotectMap.get(coded);
    }

    public Collection<String> getAllEncodedTokens() {
        return Collections.unmodifiableSet(this.unprotectMap.keySet());
    }

    private String addToken(String literal) {
        String encoded = this.longRandomString();
        this.protectMap.put(literal, encoded);
        this.unprotectMap.put(encoded, literal);
        return encoded;
    }

    private String longRandomString() {
        StringBuilder sb = new StringBuilder();
        int CHAR_MAX = GOOD_CHARS.length();
        for (int i = 0; i < 20; ++i) {
            sb.append(GOOD_CHARS.charAt(this.rnd.nextInt(CHAR_MAX)));
        }
        return sb.toString();
    }

    public String toString() {
        return this.protectMap.toString();
    }
}

