/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.okhttp.internal.http;

import com.bugvm.okhttp.Connection;
import com.bugvm.okhttp.OkHttpClient;
import com.bugvm.okhttp.TunnelRequest;
import com.bugvm.okhttp.internal.Util;
import com.bugvm.okhttp.internal.http.HttpEngine;
import com.bugvm.okhttp.internal.http.Policy;
import com.bugvm.okhttp.internal.http.RawHeaders;
import com.bugvm.okhttp.internal.http.RetryableOutputStream;
import java.io.IOException;
import java.net.CacheResponse;
import java.net.SecureCacheResponse;
import java.net.URL;
import javax.net.ssl.SSLSocket;

public final class HttpsEngine
extends HttpEngine {
    private SSLSocket sslSocket;

    public HttpsEngine(OkHttpClient client, Policy policy, String method, RawHeaders requestHeaders, Connection connection, RetryableOutputStream requestBody) throws IOException {
        super(client, policy, method, requestHeaders, connection, requestBody);
        this.sslSocket = connection != null ? (SSLSocket)connection.getSocket() : null;
    }

    @Override
    protected void connected(Connection connection) {
        this.sslSocket = (SSLSocket)connection.getSocket();
        super.connected(connection);
    }

    @Override
    protected boolean acceptCacheResponseType(CacheResponse cacheResponse) {
        return cacheResponse instanceof SecureCacheResponse;
    }

    @Override
    protected boolean includeAuthorityInRequestLine() {
        return false;
    }

    public SSLSocket getSslSocket() {
        return this.sslSocket;
    }

    @Override
    protected TunnelRequest getTunnelConfig() {
        String userAgent = this.requestHeaders.getUserAgent();
        if (userAgent == null) {
            userAgent = HttpsEngine.getDefaultUserAgent();
        }
        URL url = this.policy.getURL();
        return new TunnelRequest(url.getHost(), Util.getEffectivePort(url), userAgent, this.requestHeaders.getProxyAuthorization());
    }
}

