/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.okhttp.internal.http;

import com.bugvm.okhttp.internal.Util;
import com.bugvm.okhttp.internal.http.AbstractHttpInputStream;
import com.bugvm.okhttp.internal.http.HttpEngine;
import java.io.IOException;
import java.io.InputStream;
import java.net.CacheRequest;

final class UnknownLengthHttpInputStream
extends AbstractHttpInputStream {
    private boolean inputExhausted;

    UnknownLengthHttpInputStream(InputStream is, CacheRequest cacheRequest, HttpEngine httpEngine) throws IOException {
        super(is, httpEngine, cacheRequest);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        Util.checkOffsetAndCount(buffer.length, offset, count);
        this.checkNotClosed();
        if (this.in == null || this.inputExhausted) {
            return -1;
        }
        int read = this.in.read(buffer, offset, count);
        if (read == -1) {
            this.inputExhausted = true;
            this.endOfInput(false);
            return -1;
        }
        this.cacheWrite(buffer, offset, read);
        return read;
    }

    @Override
    public int available() throws IOException {
        this.checkNotClosed();
        return this.in == null ? 0 : this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.inputExhausted) {
            this.unexpectedEndOfInput();
        }
    }
}

