/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.okhttp.internal.spdy;

import com.bugvm.okhttp.internal.NamedRunnable;
import com.bugvm.okhttp.internal.Util;
import com.bugvm.okhttp.internal.spdy.IncomingStreamHandler;
import com.bugvm.okhttp.internal.spdy.Ping;
import com.bugvm.okhttp.internal.spdy.Settings;
import com.bugvm.okhttp.internal.spdy.SpdyReader;
import com.bugvm.okhttp.internal.spdy.SpdyStream;
import com.bugvm.okhttp.internal.spdy.SpdyWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class SpdyConnection
implements Closeable {
    static final int FLAG_FIN = 1;
    static final int FLAG_UNIDIRECTIONAL = 2;
    static final int TYPE_DATA = 0;
    static final int TYPE_SYN_STREAM = 1;
    static final int TYPE_SYN_REPLY = 2;
    static final int TYPE_RST_STREAM = 3;
    static final int TYPE_SETTINGS = 4;
    static final int TYPE_NOOP = 5;
    static final int TYPE_PING = 6;
    static final int TYPE_GOAWAY = 7;
    static final int TYPE_HEADERS = 8;
    static final int TYPE_WINDOW_UPDATE = 9;
    static final int TYPE_CREDENTIAL = 16;
    static final int VERSION = 3;
    static final int GOAWAY_OK = 0;
    static final int GOAWAY_PROTOCOL_ERROR = 1;
    static final int GOAWAY_INTERNAL_ERROR = 2;
    private static final ExecutorService executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.daemonThreadFactory("OkHttp SpdyConnection"));
    final boolean client;
    private final IncomingStreamHandler handler;
    private final SpdyReader spdyReader;
    private final SpdyWriter spdyWriter;
    private final Map<Integer, SpdyStream> streams = new HashMap<Integer, SpdyStream>();
    private final String hostName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean shutdown;
    private long idleStartTimeNs = System.nanoTime();
    private Map<Integer, Ping> pings;
    private int nextPingId;
    Settings settings;

    private SpdyConnection(Builder builder) {
        this.client = builder.client;
        this.handler = builder.handler;
        this.spdyReader = new SpdyReader(builder.in);
        this.spdyWriter = new SpdyWriter(builder.out);
        this.nextStreamId = builder.client ? 1 : 2;
        this.nextPingId = builder.client ? 1 : 2;
        this.hostName = builder.hostName;
        new Thread(new Reader(), "Spdy Reader " + this.hostName).start();
    }

    public synchronized int openStreamCount() {
        return this.streams.size();
    }

    private synchronized SpdyStream getStream(int id) {
        return this.streams.get(id);
    }

    synchronized SpdyStream removeStream(int streamId) {
        SpdyStream stream = this.streams.remove(streamId);
        if (stream != null && this.streams.isEmpty()) {
            this.setIdle(true);
        }
        return stream;
    }

    private synchronized void setIdle(boolean value) {
        this.idleStartTimeNs = value ? System.nanoTime() : 0L;
    }

    public synchronized boolean isIdle() {
        return this.idleStartTimeNs != 0L;
    }

    public synchronized long getIdleStartTimeNs() {
        return this.idleStartTimeNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpdyStream newStream(List<String> requestHeaders, boolean out, boolean in) throws IOException {
        SpdyStream stream;
        int flags = (out ? 0 : 1) | (in ? 0 : 2);
        int associatedStreamId = 0;
        int priority = 0;
        int slot = 0;
        SpdyWriter spdyWriter = this.spdyWriter;
        synchronized (spdyWriter) {
            int streamId;
            SpdyConnection spdyConnection = this;
            synchronized (spdyConnection) {
                if (this.shutdown) {
                    throw new IOException("shutdown");
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new SpdyStream(streamId, this, flags, priority, slot, requestHeaders, this.settings);
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                    this.setIdle(false);
                }
            }
            this.spdyWriter.synStream(flags, streamId, associatedStreamId, priority, slot, requestHeaders);
        }
        return stream;
    }

    void writeSynReply(int streamId, int flags, List<String> alternating) throws IOException {
        this.spdyWriter.synReply(flags, streamId, alternating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFrame(byte[] bytes, int offset, int length) throws IOException {
        SpdyWriter spdyWriter = this.spdyWriter;
        synchronized (spdyWriter) {
            this.spdyWriter.out.write(bytes, offset, length);
        }
    }

    void writeSynResetLater(final int streamId, final int statusCode) {
        executor.submit(new NamedRunnable("OkHttp SPDY Writer %s stream %d", new Object[]{this.hostName, streamId}){

            @Override
            public void execute() {
                try {
                    SpdyConnection.this.writeSynReset(streamId, statusCode);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    void writeSynReset(int streamId, int statusCode) throws IOException {
        this.spdyWriter.rstStream(streamId, statusCode);
    }

    void writeWindowUpdateLater(final int streamId, final int deltaWindowSize) {
        executor.submit(new NamedRunnable("OkHttp SPDY Writer %s stream %d", new Object[]{this.hostName, streamId}){

            @Override
            public void execute() {
                try {
                    SpdyConnection.this.writeWindowUpdate(streamId, deltaWindowSize);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    void writeWindowUpdate(int streamId, int deltaWindowSize) throws IOException {
        this.spdyWriter.windowUpdate(streamId, deltaWindowSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ping ping() throws IOException {
        int pingId;
        Ping ping = new Ping();
        SpdyConnection spdyConnection = this;
        synchronized (spdyConnection) {
            if (this.shutdown) {
                throw new IOException("shutdown");
            }
            pingId = this.nextPingId;
            this.nextPingId += 2;
            if (this.pings == null) {
                this.pings = new HashMap<Integer, Ping>();
            }
            this.pings.put(pingId, ping);
        }
        this.writePing(pingId, ping);
        return ping;
    }

    private void writePingLater(final int streamId, final Ping ping) {
        executor.submit(new NamedRunnable("OkHttp SPDY Writer %s ping %d", new Object[]{this.hostName, streamId}){

            @Override
            public void execute() {
                try {
                    SpdyConnection.this.writePing(streamId, ping);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePing(int id, Ping ping) throws IOException {
        SpdyWriter spdyWriter = this.spdyWriter;
        synchronized (spdyWriter) {
            if (ping != null) {
                ping.send();
            }
            this.spdyWriter.ping(0, id);
        }
    }

    private synchronized Ping removePing(int id) {
        return this.pings != null ? this.pings.remove(id) : null;
    }

    public void noop() throws IOException {
        this.spdyWriter.noop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        SpdyWriter spdyWriter = this.spdyWriter;
        synchronized (spdyWriter) {
            this.spdyWriter.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(int statusCode) throws IOException {
        SpdyWriter spdyWriter = this.spdyWriter;
        synchronized (spdyWriter) {
            int lastGoodStreamId;
            SpdyConnection spdyConnection = this;
            synchronized (spdyConnection) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                lastGoodStreamId = this.lastGoodStreamId;
            }
            this.spdyWriter.goAway(0, lastGoodStreamId, statusCode);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(0, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(int shutdownStatusCode, int rstStatusCode) throws IOException {
        assert (!Thread.holdsLock(this));
        IOException thrown = null;
        try {
            this.shutdown(shutdownStatusCode);
        }
        catch (IOException e) {
            thrown = e;
        }
        SpdyStream[] streamsToClose = null;
        Ping[] pingsToCancel = null;
        SpdyStream[] spdyStreamArray = this;
        synchronized (this) {
            block19: {
                if (!this.streams.isEmpty()) {
                    streamsToClose = this.streams.values().toArray(new SpdyStream[this.streams.size()]);
                    this.streams.clear();
                    super.setIdle(false);
                }
                if (this.pings != null) {
                    pingsToCancel = this.pings.values().toArray(new Ping[this.pings.size()]);
                    this.pings = null;
                }
                // ** MonitorExit[spdyStreamArray] (shouldn't be in output)
                if (streamsToClose != null) {
                    for (SpdyStream spdyStream : streamsToClose) {
                        try {
                            spdyStream.close(rstStatusCode);
                        }
                        catch (IOException e) {
                            if (thrown == null) continue;
                            thrown = e;
                        }
                    }
                }
                if (pingsToCancel != null) {
                    for (SpdyStream spdyStream : pingsToCancel) {
                        ((Ping)((Object)spdyStream)).cancel();
                    }
                }
                try {
                    this.spdyReader.close();
                }
                catch (IOException e) {
                    thrown = e;
                }
                try {
                    this.spdyWriter.close();
                }
                catch (IOException e) {
                    if (thrown != null) break block19;
                    thrown = e;
                }
            }
            if (thrown != null) {
                throw thrown;
            }
            return;
        }
    }

    private class Reader
    implements Runnable,
    SpdyReader.Handler {
        private Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int shutdownStatusCode = 2;
            int rstStatusCode = 6;
            try {
                while (SpdyConnection.this.spdyReader.nextFrame(this)) {
                }
                shutdownStatusCode = 0;
                rstStatusCode = 5;
            }
            catch (IOException e) {
                shutdownStatusCode = 1;
                rstStatusCode = 1;
            }
            finally {
                try {
                    SpdyConnection.this.close(shutdownStatusCode, rstStatusCode);
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public void data(int flags, int streamId, InputStream in, int length) throws IOException {
            SpdyStream dataStream = SpdyConnection.this.getStream(streamId);
            if (dataStream == null) {
                SpdyConnection.this.writeSynResetLater(streamId, 2);
                Util.skipByReading(in, length);
                return;
            }
            dataStream.receiveData(in, length);
            if ((flags & 1) != 0) {
                dataStream.receiveFin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void synStream(int flags, int streamId, int associatedStreamId, int priority, int slot, List<String> nameValueBlock) {
            SpdyStream previous;
            SpdyStream synStream;
            SpdyConnection spdyConnection = SpdyConnection.this;
            synchronized (spdyConnection) {
                synStream = new SpdyStream(streamId, SpdyConnection.this, flags, priority, slot, nameValueBlock, SpdyConnection.this.settings);
                if (SpdyConnection.this.shutdown) {
                    return;
                }
                SpdyConnection.this.lastGoodStreamId = streamId;
                previous = SpdyConnection.this.streams.put(streamId, synStream);
            }
            if (previous != null) {
                previous.closeLater(1);
                SpdyConnection.this.removeStream(streamId);
                return;
            }
            executor.submit(new NamedRunnable("OkHttp SPDY Callback %s stream %d", new Object[]{SpdyConnection.this.hostName, streamId}){

                @Override
                public void execute() {
                    try {
                        SpdyConnection.this.handler.receive(synStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        @Override
        public void synReply(int flags, int streamId, List<String> nameValueBlock) throws IOException {
            SpdyStream replyStream = SpdyConnection.this.getStream(streamId);
            if (replyStream == null) {
                SpdyConnection.this.writeSynResetLater(streamId, 2);
                return;
            }
            replyStream.receiveReply(nameValueBlock);
            if ((flags & 1) != 0) {
                replyStream.receiveFin();
            }
        }

        @Override
        public void headers(int flags, int streamId, List<String> nameValueBlock) throws IOException {
            SpdyStream replyStream = SpdyConnection.this.getStream(streamId);
            if (replyStream != null) {
                replyStream.receiveHeaders(nameValueBlock);
            }
        }

        @Override
        public void rstStream(int flags, int streamId, int statusCode) {
            SpdyStream rstStream = SpdyConnection.this.removeStream(streamId);
            if (rstStream != null) {
                rstStream.receiveRstStream(statusCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void settings(int flags, Settings newSettings) {
            SpdyStream[] streamsToNotify = null;
            SpdyConnection spdyConnection = SpdyConnection.this;
            synchronized (spdyConnection) {
                if (SpdyConnection.this.settings == null || (flags & 1) != 0) {
                    SpdyConnection.this.settings = newSettings;
                } else {
                    SpdyConnection.this.settings.merge(newSettings);
                }
                if (!SpdyConnection.this.streams.isEmpty()) {
                    streamsToNotify = SpdyConnection.this.streams.values().toArray(new SpdyStream[SpdyConnection.this.streams.size()]);
                }
            }
            if (streamsToNotify != null) {
                spdyConnection = streamsToNotify;
                int n = ((SpdyConnection)spdyConnection).length;
                for (int i = 0; i < n; ++i) {
                    SpdyConnection stream;
                    SpdyConnection spdyConnection2 = stream = spdyConnection[i];
                    synchronized (spdyConnection2) {
                        SpdyConnection spdyConnection3 = SpdyConnection.this;
                        synchronized (spdyConnection3) {
                            ((SpdyStream)((Object)stream)).receiveSettings(SpdyConnection.this.settings);
                        }
                    }
                }
            }
        }

        @Override
        public void noop() {
        }

        @Override
        public void ping(int flags, int streamId) {
            if (SpdyConnection.this.client != (streamId % 2 == 1)) {
                SpdyConnection.this.writePingLater(streamId, null);
            } else {
                Ping ping = SpdyConnection.this.removePing(streamId);
                if (ping != null) {
                    ping.receive();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int flags, int lastGoodStreamId, int statusCode) {
            SpdyConnection spdyConnection = SpdyConnection.this;
            synchronized (spdyConnection) {
                SpdyConnection.this.shutdown = true;
                Iterator i = SpdyConnection.this.streams.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    int streamId = (Integer)entry.getKey();
                    if (streamId <= lastGoodStreamId || !((SpdyStream)entry.getValue()).isLocallyInitiated()) continue;
                    ((SpdyStream)entry.getValue()).receiveRstStream(3);
                    i.remove();
                }
            }
        }

        @Override
        public void windowUpdate(int flags, int streamId, int deltaWindowSize) {
            SpdyStream stream = SpdyConnection.this.getStream(streamId);
            if (stream != null) {
                stream.receiveWindowUpdate(deltaWindowSize);
            }
        }
    }

    public static class Builder {
        private String hostName;
        private InputStream in;
        private OutputStream out;
        private IncomingStreamHandler handler = IncomingStreamHandler.REFUSE_INCOMING_STREAMS;
        public boolean client;

        public Builder(boolean client, Socket socket) throws IOException {
            this("", client, socket.getInputStream(), socket.getOutputStream());
        }

        public Builder(boolean client, InputStream in, OutputStream out) {
            this("", client, in, out);
        }

        public Builder(String hostName, boolean client, Socket socket) throws IOException {
            this(hostName, client, socket.getInputStream(), socket.getOutputStream());
        }

        public Builder(String hostName, boolean client, InputStream in, OutputStream out) {
            this.hostName = hostName;
            this.client = client;
            this.in = in;
            this.out = out;
        }

        public Builder handler(IncomingStreamHandler handler) {
            this.handler = handler;
            return this;
        }

        public SpdyConnection build() {
            return new SpdyConnection(this);
        }
    }
}

