/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.okhttp.internal.spdy;

import com.bugvm.okhttp.internal.Platform;
import com.bugvm.okhttp.internal.Util;
import com.bugvm.okhttp.internal.spdy.Settings;
import com.bugvm.okhttp.internal.spdy.SpdyReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.Deflater;

final class SpdyWriter
implements Closeable {
    final DataOutputStream out;
    private final ByteArrayOutputStream nameValueBlockBuffer;
    private final DataOutputStream nameValueBlockOut;

    SpdyWriter(OutputStream out) {
        this.out = new DataOutputStream(out);
        Deflater deflater = new Deflater();
        deflater.setDictionary(SpdyReader.DICTIONARY);
        this.nameValueBlockBuffer = new ByteArrayOutputStream();
        this.nameValueBlockOut = new DataOutputStream(Platform.get().newDeflaterOutputStream(this.nameValueBlockBuffer, deflater, true));
    }

    public synchronized void synStream(int flags, int streamId, int associatedStreamId, int priority, int slot, List<String> nameValueBlock) throws IOException {
        this.writeNameValueBlockToBuffer(nameValueBlock);
        int length = 10 + this.nameValueBlockBuffer.size();
        int type = 1;
        int unused = 0;
        this.out.writeInt(0x80030000 | type & 0xFFFF);
        this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
        this.out.writeInt(streamId & Integer.MAX_VALUE);
        this.out.writeInt(associatedStreamId & Integer.MAX_VALUE);
        this.out.writeShort((priority & 7) << 13 | (unused & 0x1F) << 8 | slot & 0xFF);
        this.nameValueBlockBuffer.writeTo(this.out);
        this.out.flush();
    }

    public synchronized void synReply(int flags, int streamId, List<String> nameValueBlock) throws IOException {
        this.writeNameValueBlockToBuffer(nameValueBlock);
        int type = 2;
        int length = this.nameValueBlockBuffer.size() + 4;
        this.out.writeInt(0x80030000 | type & 0xFFFF);
        this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
        this.out.writeInt(streamId & Integer.MAX_VALUE);
        this.nameValueBlockBuffer.writeTo(this.out);
        this.out.flush();
    }

    public synchronized void headers(int flags, int streamId, List<String> nameValueBlock) throws IOException {
        this.writeNameValueBlockToBuffer(nameValueBlock);
        int type = 8;
        int length = this.nameValueBlockBuffer.size() + 4;
        this.out.writeInt(0x80030000 | type & 0xFFFF);
        this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
        this.out.writeInt(streamId & Integer.MAX_VALUE);
        this.nameValueBlockBuffer.writeTo(this.out);
        this.out.flush();
    }

    public synchronized void rstStream(int streamId, int statusCode) throws IOException {
        int flags = 0;
        int type = 3;
        int length = 8;
        this.out.writeInt(0x80030000 | type & 0xFFFF);
        this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
        this.out.writeInt(streamId & Integer.MAX_VALUE);
        this.out.writeInt(statusCode);
        this.out.flush();
    }

    public synchronized void data(int flags, int streamId, byte[] data) throws IOException {
        int length = data.length;
        this.out.writeInt(streamId & Integer.MAX_VALUE);
        this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
        this.out.write(data);
        this.out.flush();
    }

    private void writeNameValueBlockToBuffer(List<String> nameValueBlock) throws IOException {
        this.nameValueBlockBuffer.reset();
        int numberOfPairs = nameValueBlock.size() / 2;
        this.nameValueBlockOut.writeInt(numberOfPairs);
        for (String s : nameValueBlock) {
            this.nameValueBlockOut.writeInt(s.length());
            this.nameValueBlockOut.write(s.getBytes("UTF-8"));
        }
        this.nameValueBlockOut.flush();
    }

    public synchronized void settings(int flags, Settings settings) throws IOException {
        int type = 4;
        int size = settings.size();
        int length = 4 + size * 8;
        this.out.writeInt(0x80030000 | type & 0xFFFF);
        this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
        this.out.writeInt(size);
        for (int i = 0; i <= 9; ++i) {
            if (!settings.isSet(i)) continue;
            int settingsFlags = settings.flags(i);
            this.out.writeInt((settingsFlags & 0xFF) << 24 | i & 0xFFFFFF);
            this.out.writeInt(settings.get(i));
        }
        this.out.flush();
    }

    public synchronized void noop() throws IOException {
        int type = 5;
        int length = 0;
        int flags = 0;
        this.out.writeInt(0x80030000 | type & 0xFFFF);
        this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
        this.out.flush();
    }

    public synchronized void ping(int flags, int id) throws IOException {
        int type = 6;
        int length = 4;
        this.out.writeInt(0x80030000 | type & 0xFFFF);
        this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
        this.out.writeInt(id);
        this.out.flush();
    }

    public synchronized void goAway(int flags, int lastGoodStreamId, int statusCode) throws IOException {
        int type = 7;
        int length = 8;
        this.out.writeInt(0x80030000 | type & 0xFFFF);
        this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
        this.out.writeInt(lastGoodStreamId);
        this.out.writeInt(statusCode);
        this.out.flush();
    }

    public synchronized void windowUpdate(int streamId, int deltaWindowSize) throws IOException {
        int type = 9;
        int flags = 0;
        int length = 8;
        this.out.writeInt(0x80030000 | type & 0xFFFF);
        this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
        this.out.writeInt(streamId);
        this.out.writeInt(deltaWindowSize);
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        Util.closeAll(this.out, this.nameValueBlockOut);
    }
}

