/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.rt.bro;

import com.bugvm.rt.VM;
import com.bugvm.rt.bro.annotation.MarshalsArray;
import com.bugvm.rt.bro.annotation.MarshalsPointer;

public class ArrayMarshalers {
    private static void checkDimensions(String type, String suffix, int actual, int expected) {
        if (actual != expected) {
            throw new IllegalArgumentException("Expected " + type + "[" + expected + "]" + suffix + ". Got " + type + "[" + actual + "]" + suffix);
        }
    }

    public static class DoubleArrayMarshaler {
        private static final String TYPE = "double";
        private static final int SHIFT = 3;

        @MarshalsPointer(supportedCallTypes={0L})
        public static long toNative(double[] o, long flags) {
            if (o == null) {
                return 0L;
            }
            return VM.getArrayValuesAddress(o);
        }

        @MarshalsArray
        public static double[] toObject(Class<?> arrayClass, long handle, long flags, int d1) {
            double[] o = new double[d1];
            int off = d1 << 3;
            VM.memcpy(VM.getArrayValuesAddress(o), handle, off);
            return o;
        }

        @MarshalsArray
        public static void toNative(double[] o, long handle, long flags, int d1) {
            int off = d1 << 3;
            ArrayMarshalers.checkDimensions(TYPE, "", o.length, d1);
            VM.memcpy(handle, VM.getArrayValuesAddress(o), off);
        }

        @MarshalsArray
        public static double[][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2) {
            double[][] o = new double[d1][d2];
            int off = d2 << 3;
            for (int i = 0; i < d1; ++i) {
                VM.memcpy(VM.getArrayValuesAddress(o[i]), handle, off);
                handle += (long)off;
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(double[][] o, long handle, long flags, int d1, int d2) {
            int i;
            int off = d2 << 3;
            ArrayMarshalers.checkDimensions(TYPE, "[]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                ArrayMarshalers.checkDimensions("double[]", "", o[i].length, d2);
            }
            for (i = 0; i < len1; ++i) {
                VM.memcpy(handle, VM.getArrayValuesAddress(o[i]), off);
                handle += (long)off;
            }
        }

        @MarshalsArray
        public static double[][][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2, int d3) {
            double[][][] o = new double[d1][d2][d3];
            int off = d3 << 3;
            for (int i = 0; i < d1; ++i) {
                for (int j = 0; j < d2; ++j) {
                    VM.memcpy(VM.getArrayValuesAddress(o[i][j]), handle, off);
                    handle += (long)off;
                }
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(double[][][] o, long handle, long flags, int d1, int d2, int d3) {
            int j;
            int len2;
            double[][] p;
            int i;
            int off = d3 << 3;
            ArrayMarshalers.checkDimensions(TYPE, "[][]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                p = o[i];
                ArrayMarshalers.checkDimensions("double[]", "[]", p.length, d2);
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    ArrayMarshalers.checkDimensions("double[][]", "", p[j].length, d3);
                }
            }
            for (i = 0; i < len1; ++i) {
                p = o[i];
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    VM.memcpy(handle, VM.getArrayValuesAddress(p[j]), off);
                    handle += (long)off;
                }
            }
        }
    }

    public static class FloatArrayMarshaler {
        private static final String TYPE = "float";
        private static final int SHIFT = 2;

        @MarshalsPointer(supportedCallTypes={0L})
        public static long toNative(float[] o, long flags) {
            if (o == null) {
                return 0L;
            }
            return VM.getArrayValuesAddress(o);
        }

        @MarshalsArray
        public static float[] toObject(Class<?> arrayClass, long handle, long flags, int d1) {
            float[] o = new float[d1];
            int off = d1 << 2;
            VM.memcpy(VM.getArrayValuesAddress(o), handle, off);
            return o;
        }

        @MarshalsArray
        public static void toNative(float[] o, long handle, long flags, int d1) {
            int off = d1 << 2;
            ArrayMarshalers.checkDimensions(TYPE, "", o.length, d1);
            VM.memcpy(handle, VM.getArrayValuesAddress(o), off);
        }

        @MarshalsArray
        public static float[][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2) {
            float[][] o = new float[d1][d2];
            int off = d2 << 2;
            for (int i = 0; i < d1; ++i) {
                VM.memcpy(VM.getArrayValuesAddress(o[i]), handle, off);
                handle += (long)off;
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(float[][] o, long handle, long flags, int d1, int d2) {
            int i;
            int off = d2 << 2;
            ArrayMarshalers.checkDimensions(TYPE, "[]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                ArrayMarshalers.checkDimensions("float[]", "", o[i].length, d2);
            }
            for (i = 0; i < len1; ++i) {
                VM.memcpy(handle, VM.getArrayValuesAddress(o[i]), off);
                handle += (long)off;
            }
        }

        @MarshalsArray
        public static float[][][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2, int d3) {
            float[][][] o = new float[d1][d2][d3];
            int off = d3 << 2;
            for (int i = 0; i < d1; ++i) {
                for (int j = 0; j < d2; ++j) {
                    VM.memcpy(VM.getArrayValuesAddress(o[i][j]), handle, off);
                    handle += (long)off;
                }
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(float[][][] o, long handle, long flags, int d1, int d2, int d3) {
            int j;
            int len2;
            float[][] p;
            int i;
            int off = d3 << 2;
            ArrayMarshalers.checkDimensions(TYPE, "[][]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                p = o[i];
                ArrayMarshalers.checkDimensions("float[]", "[]", p.length, d2);
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    ArrayMarshalers.checkDimensions("float[][]", "", p[j].length, d3);
                }
            }
            for (i = 0; i < len1; ++i) {
                p = o[i];
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    VM.memcpy(handle, VM.getArrayValuesAddress(p[j]), off);
                    handle += (long)off;
                }
            }
        }
    }

    public static class LongArrayMarshaler {
        private static final String TYPE = "long";
        private static final int SHIFT = 3;

        @MarshalsPointer(supportedCallTypes={0L})
        public static long toNative(long[] o, long flags) {
            if (o == null) {
                return 0L;
            }
            return VM.getArrayValuesAddress(o);
        }

        @MarshalsArray
        public static long[] toObject(Class<?> arrayClass, long handle, long flags, int d1) {
            long[] o = new long[d1];
            int off = d1 << 3;
            VM.memcpy(VM.getArrayValuesAddress(o), handle, off);
            return o;
        }

        @MarshalsArray
        public static void toNative(long[] o, long handle, long flags, int d1) {
            int off = d1 << 3;
            ArrayMarshalers.checkDimensions(TYPE, "", o.length, d1);
            VM.memcpy(handle, VM.getArrayValuesAddress(o), off);
        }

        @MarshalsArray
        public static long[][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2) {
            long[][] o = new long[d1][d2];
            int off = d2 << 3;
            for (int i = 0; i < d1; ++i) {
                VM.memcpy(VM.getArrayValuesAddress(o[i]), handle, off);
                handle += (long)off;
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(long[][] o, long handle, long flags, int d1, int d2) {
            int i;
            int off = d2 << 3;
            ArrayMarshalers.checkDimensions(TYPE, "[]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                ArrayMarshalers.checkDimensions("long[]", "", o[i].length, d2);
            }
            for (i = 0; i < len1; ++i) {
                VM.memcpy(handle, VM.getArrayValuesAddress(o[i]), off);
                handle += (long)off;
            }
        }

        @MarshalsArray
        public static long[][][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2, int d3) {
            long[][][] o = new long[d1][d2][d3];
            int off = d3 << 3;
            for (int i = 0; i < d1; ++i) {
                for (int j = 0; j < d2; ++j) {
                    VM.memcpy(VM.getArrayValuesAddress(o[i][j]), handle, off);
                    handle += (long)off;
                }
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(long[][][] o, long handle, long flags, int d1, int d2, int d3) {
            int j;
            int len2;
            long[][] p;
            int i;
            int off = d3 << 3;
            ArrayMarshalers.checkDimensions(TYPE, "[][]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                p = o[i];
                ArrayMarshalers.checkDimensions("long[]", "[]", p.length, d2);
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    ArrayMarshalers.checkDimensions("long[][]", "", p[j].length, d3);
                }
            }
            for (i = 0; i < len1; ++i) {
                p = o[i];
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    VM.memcpy(handle, VM.getArrayValuesAddress(p[j]), off);
                    handle += (long)off;
                }
            }
        }
    }

    public static class IntArrayMarshaler {
        private static final String TYPE = "int";
        private static final int SHIFT = 2;

        @MarshalsPointer(supportedCallTypes={0L})
        public static long toNative(int[] o, long flags) {
            if (o == null) {
                return 0L;
            }
            return VM.getArrayValuesAddress(o);
        }

        @MarshalsArray
        public static int[] toObject(Class<?> arrayClass, long handle, long flags, int d1) {
            int[] o = new int[d1];
            int off = d1 << 2;
            VM.memcpy(VM.getArrayValuesAddress(o), handle, off);
            return o;
        }

        @MarshalsArray
        public static void toNative(int[] o, long handle, long flags, int d1) {
            int off = d1 << 2;
            ArrayMarshalers.checkDimensions(TYPE, "", o.length, d1);
            VM.memcpy(handle, VM.getArrayValuesAddress(o), off);
        }

        @MarshalsArray
        public static int[][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2) {
            int[][] o = new int[d1][d2];
            int off = d2 << 2;
            for (int i = 0; i < d1; ++i) {
                VM.memcpy(VM.getArrayValuesAddress(o[i]), handle, off);
                handle += (long)off;
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(int[][] o, long handle, long flags, int d1, int d2) {
            int i;
            int off = d2 << 2;
            ArrayMarshalers.checkDimensions(TYPE, "[]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                ArrayMarshalers.checkDimensions("int[]", "", o[i].length, d2);
            }
            for (i = 0; i < len1; ++i) {
                VM.memcpy(handle, VM.getArrayValuesAddress(o[i]), off);
                handle += (long)off;
            }
        }

        @MarshalsArray
        public static int[][][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2, int d3) {
            int[][][] o = new int[d1][d2][d3];
            int off = d3 << 2;
            for (int i = 0; i < d1; ++i) {
                for (int j = 0; j < d2; ++j) {
                    VM.memcpy(VM.getArrayValuesAddress(o[i][j]), handle, off);
                    handle += (long)off;
                }
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(int[][][] o, long handle, long flags, int d1, int d2, int d3) {
            int j;
            int len2;
            int[][] p;
            int i;
            int off = d3 << 2;
            ArrayMarshalers.checkDimensions(TYPE, "[][]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                p = o[i];
                ArrayMarshalers.checkDimensions("int[]", "[]", p.length, d2);
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    ArrayMarshalers.checkDimensions("int[][]", "", p[j].length, d3);
                }
            }
            for (i = 0; i < len1; ++i) {
                p = o[i];
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    VM.memcpy(handle, VM.getArrayValuesAddress(p[j]), off);
                    handle += (long)off;
                }
            }
        }
    }

    public static class CharArrayMarshaler {
        private static final String TYPE = "char";
        private static final int SHIFT = 1;

        @MarshalsPointer(supportedCallTypes={0L})
        public static long toNative(char[] o, long flags) {
            if (o == null) {
                return 0L;
            }
            return VM.getArrayValuesAddress(o);
        }

        @MarshalsArray
        public static char[] toObject(Class<?> arrayClass, long handle, long flags, int d1) {
            char[] o = new char[d1];
            int off = d1 << 1;
            VM.memcpy(VM.getArrayValuesAddress(o), handle, off);
            return o;
        }

        @MarshalsArray
        public static void toNative(char[] o, long handle, long flags, int d1) {
            int off = d1 << 1;
            ArrayMarshalers.checkDimensions(TYPE, "", o.length, d1);
            VM.memcpy(handle, VM.getArrayValuesAddress(o), off);
        }

        @MarshalsArray
        public static char[][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2) {
            char[][] o = new char[d1][d2];
            int off = d2 << 1;
            for (int i = 0; i < d1; ++i) {
                VM.memcpy(VM.getArrayValuesAddress(o[i]), handle, off);
                handle += (long)off;
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(char[][] o, long handle, long flags, int d1, int d2) {
            int i;
            int off = d2 << 1;
            ArrayMarshalers.checkDimensions(TYPE, "[]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                ArrayMarshalers.checkDimensions("char[]", "", o[i].length, d2);
            }
            for (i = 0; i < len1; ++i) {
                VM.memcpy(handle, VM.getArrayValuesAddress(o[i]), off);
                handle += (long)off;
            }
        }

        @MarshalsArray
        public static char[][][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2, int d3) {
            char[][][] o = new char[d1][d2][d3];
            int off = d3 << 1;
            for (int i = 0; i < d1; ++i) {
                for (int j = 0; j < d2; ++j) {
                    VM.memcpy(VM.getArrayValuesAddress(o[i][j]), handle, off);
                    handle += (long)off;
                }
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(char[][][] o, long handle, long flags, int d1, int d2, int d3) {
            int j;
            int len2;
            char[][] p;
            int i;
            int off = d3 << 1;
            ArrayMarshalers.checkDimensions(TYPE, "[][]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                p = o[i];
                ArrayMarshalers.checkDimensions("char[]", "[]", p.length, d2);
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    ArrayMarshalers.checkDimensions("char[][]", "", p[j].length, d3);
                }
            }
            for (i = 0; i < len1; ++i) {
                p = o[i];
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    VM.memcpy(handle, VM.getArrayValuesAddress(p[j]), off);
                    handle += (long)off;
                }
            }
        }
    }

    public static class ShortArrayMarshaler {
        private static final String TYPE = "short";
        private static final int SHIFT = 1;

        @MarshalsPointer(supportedCallTypes={0L})
        public static long toNative(short[] o, long flags) {
            if (o == null) {
                return 0L;
            }
            return VM.getArrayValuesAddress(o);
        }

        @MarshalsArray
        public static short[] toObject(Class<?> arrayClass, long handle, long flags, int d1) {
            short[] o = new short[d1];
            int off = d1 << 1;
            VM.memcpy(VM.getArrayValuesAddress(o), handle, off);
            return o;
        }

        @MarshalsArray
        public static void toNative(short[] o, long handle, long flags, int d1) {
            int off = d1 << 1;
            ArrayMarshalers.checkDimensions(TYPE, "", o.length, d1);
            VM.memcpy(handle, VM.getArrayValuesAddress(o), off);
        }

        @MarshalsArray
        public static short[][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2) {
            short[][] o = new short[d1][d2];
            int off = d2 << 1;
            for (int i = 0; i < d1; ++i) {
                VM.memcpy(VM.getArrayValuesAddress(o[i]), handle, off);
                handle += (long)off;
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(short[][] o, long handle, long flags, int d1, int d2) {
            int i;
            int off = d2 << 1;
            ArrayMarshalers.checkDimensions(TYPE, "[]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                ArrayMarshalers.checkDimensions("short[]", "", o[i].length, d2);
            }
            for (i = 0; i < len1; ++i) {
                VM.memcpy(handle, VM.getArrayValuesAddress(o[i]), off);
                handle += (long)off;
            }
        }

        @MarshalsArray
        public static short[][][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2, int d3) {
            short[][][] o = new short[d1][d2][d3];
            int off = d3 << 1;
            for (int i = 0; i < d1; ++i) {
                for (int j = 0; j < d2; ++j) {
                    VM.memcpy(VM.getArrayValuesAddress(o[i][j]), handle, off);
                    handle += (long)off;
                }
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(short[][][] o, long handle, long flags, int d1, int d2, int d3) {
            int j;
            int len2;
            short[][] p;
            int i;
            int off = d3 << 1;
            ArrayMarshalers.checkDimensions(TYPE, "[][]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                p = o[i];
                ArrayMarshalers.checkDimensions("short[]", "[]", p.length, d2);
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    ArrayMarshalers.checkDimensions("short[][]", "", p[j].length, d3);
                }
            }
            for (i = 0; i < len1; ++i) {
                p = o[i];
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    VM.memcpy(handle, VM.getArrayValuesAddress(p[j]), off);
                    handle += (long)off;
                }
            }
        }
    }

    public static class ByteArrayMarshaler {
        private static final String TYPE = "byte";
        private static final int SHIFT = 0;

        @MarshalsPointer(supportedCallTypes={0L})
        public static long toNative(byte[] o, long flags) {
            if (o == null) {
                return 0L;
            }
            return VM.getArrayValuesAddress(o);
        }

        @MarshalsArray
        public static byte[] toObject(Class<?> arrayClass, long handle, long flags, int d1) {
            byte[] o = new byte[d1];
            int off = d1 << 0;
            VM.memcpy(VM.getArrayValuesAddress(o), handle, off);
            return o;
        }

        @MarshalsArray
        public static void toNative(byte[] o, long handle, long flags, int d1) {
            int off = d1 << 0;
            ArrayMarshalers.checkDimensions(TYPE, "", o.length, d1);
            VM.memcpy(handle, VM.getArrayValuesAddress(o), off);
        }

        @MarshalsArray
        public static byte[][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2) {
            byte[][] o = new byte[d1][d2];
            int off = d2 << 0;
            for (int i = 0; i < d1; ++i) {
                VM.memcpy(VM.getArrayValuesAddress(o[i]), handle, off);
                handle += (long)off;
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(byte[][] o, long handle, long flags, int d1, int d2) {
            int i;
            int off = d2 << 0;
            ArrayMarshalers.checkDimensions(TYPE, "[]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                ArrayMarshalers.checkDimensions("byte[]", "", o[i].length, d2);
            }
            for (i = 0; i < len1; ++i) {
                VM.memcpy(handle, VM.getArrayValuesAddress(o[i]), off);
                handle += (long)off;
            }
        }

        @MarshalsArray
        public static byte[][][] toObject(Class<?> arrayClass, long handle, long flags, int d1, int d2, int d3) {
            byte[][][] o = new byte[d1][d2][d3];
            int off = d3 << 0;
            for (int i = 0; i < d1; ++i) {
                for (int j = 0; j < d2; ++j) {
                    VM.memcpy(VM.getArrayValuesAddress(o[i][j]), handle, off);
                    handle += (long)off;
                }
            }
            return o;
        }

        @MarshalsArray
        public static void toNative(byte[][][] o, long handle, long flags, int d1, int d2, int d3) {
            int j;
            int len2;
            byte[][] p;
            int i;
            int off = d3 << 0;
            ArrayMarshalers.checkDimensions(TYPE, "[][]", o.length, d1);
            int len1 = o.length;
            for (i = 0; i < len1; ++i) {
                p = o[i];
                ArrayMarshalers.checkDimensions("byte[]", "[]", p.length, d2);
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    ArrayMarshalers.checkDimensions("byte[][]", "", p[j].length, d3);
                }
            }
            for (i = 0; i < len1; ++i) {
                p = o[i];
                len2 = p.length;
                for (j = 0; j < len2; ++j) {
                    VM.memcpy(handle, VM.getArrayValuesAddress(p[j]), off);
                    handle += (long)off;
                }
            }
        }
    }
}

