/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.rt.bro;

import com.bugvm.rt.VM;
import com.bugvm.rt.bro.annotation.MachineSizedUInt;
import com.bugvm.rt.bro.annotation.Marshaler;
import com.bugvm.rt.bro.annotation.MarshalsValue;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

@Marshaler(value=AsIntMarshaler.class)
public abstract class Bits<T extends Bits<T>>
implements Iterable<T>,
Comparable<T> {
    private long value;
    private long mask;
    private String name;

    protected Bits(long value) {
        this.value = value;
        this.mask = value == 0L ? -1L : value;
    }

    protected Bits(long value, long mask) {
        this.value = value;
        this.mask = mask;
    }

    public static <T extends Bits<T>> T with(T t) {
        try {
            return (T)((Bits)t.getClass().getDeclaredConstructor(Long.TYPE).newInstance(t.value()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public static <T extends Bits<T>> T with(T t1, T t2) {
        T t = Bits.with(t1);
        return t.set(t2);
    }

    public static <T extends Bits<T>> T with(T t1, T t2, T t3) {
        T t = Bits.with(t1, t2);
        return t.set(t3);
    }

    public static <T extends Bits<T>> T with(T t1, T t2, T t3, T t4) {
        T t = Bits.with(t1, t2, t3);
        return t.set(t4);
    }

    public static <T extends Bits<T>> T with(T t1, T t2, T t3, T t4, T t5) {
        T t = Bits.with(t1, t2, t3, t4);
        return t.set(t5);
    }

    @SafeVarargs
    public static <T extends Bits<T>> T with(T start, T ... others) {
        Object t = Bits.with(start);
        for (T e : others) {
            t = ((Bits)t).set(e);
        }
        return (T)t;
    }

    public long value() {
        return this.value;
    }

    protected abstract T wrap(long var1, long var3);

    protected abstract T[] _values();

    public T set(T bits) {
        T bits_ = bits;
        return this.wrap(this.value & (((Bits)bits_).mask ^ 0xFFFFFFFFFFFFFFFFL) | ((Bits)bits_).value, this.mask | ((Bits)bits_).mask);
    }

    public T clear(T bits) {
        T bits_ = bits;
        if (((Bits)bits_).value == 0L) {
            return (T)this;
        }
        return this.wrap(this.value & (((Bits)bits_).mask ^ 0xFFFFFFFFFFFFFFFFL), this.mask & (((Bits)bits_).mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public boolean contains(T bits) {
        T bits_ = bits;
        return (((Bits)bits_).mask & this.value) == ((Bits)bits_).value;
    }

    @Override
    public Iterator<T> iterator() {
        return this.asSet().iterator();
    }

    private static int cardinality(long l) {
        int c = 0;
        for (int i = 0; i < 64; ++i) {
            if ((l & 1L << i) == 0L) continue;
            ++c;
        }
        return c;
    }

    public Set<T> asSet() {
        Bits[] all = this._values();
        Arrays.sort(all, new Comparator<T>(){

            @Override
            public int compare(T lhs, T rhs) {
                Object lhs_ = lhs;
                Object rhs_ = rhs;
                return Long.compare(Bits.cardinality(((Bits)rhs_).mask), Bits.cardinality(((Bits)lhs_).mask));
            }
        });
        TreeSet<Bits> values2 = new TreeSet<Bits>();
        long value = this.value;
        Bits[] bitsArray = all;
        int n = bitsArray.length;
        for (int i = 0; i < n; ++i) {
            Bits bits;
            Bits bits_ = bits = bitsArray[i];
            if ((value & bits_.mask) != bits_.value) continue;
            values2.add(bits);
            if ((value &= bits_.mask ^ 0xFFFFFFFFFFFFFFFFL) == 0L) break;
        }
        if (value != 0L) {
            values2.add((Bits)this.wrap(value, value));
        } else if (values2.isEmpty()) {
            values2.add(this);
        }
        return values2;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bits other = (Bits)obj;
        return this.value == other.value;
    }

    @Override
    public int compareTo(T another) {
        T another_ = another;
        int c = Long.compare(this.mask, ((Bits)another_).mask);
        return c == 0 ? Long.compare(this.value, ((Bits)another_).value) : c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(0x");
        sb.append(Long.toHexString(this.value));
        sb.append(" = ");
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            Bits bits = (Bits)it.next();
            if (bits.name != null) {
                sb.append(bits.name);
                sb.append("(0x");
                sb.append(Long.toHexString(bits.value));
                sb.append(')');
            } else {
                sb.append("0x");
                sb.append(Long.toHexString(bits.value));
            }
            if (!it.hasNext()) continue;
            sb.append(" | ");
        }
        sb.append(')');
        return sb.toString();
    }

    protected static <T extends Bits<T>> T[] _values(Class<T> cls) {
        if (!Bits.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(cls.getName() + " is not a subclass of " + Bits.class);
        }
        try {
            TreeSet<Bits> values2 = new TreeSet<Bits>();
            for (Field field : cls.getDeclaredFields()) {
                Bits bits;
                int mod = field.getModifiers();
                if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod) || !Modifier.isFinal(mod) || field.getType() != cls) continue;
                Bits bits_ = bits = (Bits)field.get(null);
                bits_.name = field.getName();
                if (bits_.mask == 0L) continue;
                values2.add(bits);
            }
            return values2.toArray((Bits[])Array.newInstance(cls, values2.size()));
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    public static class AsMachineSizedIntMarshaler {
        @MarshalsValue
        public static Bits<?> toObject(Class<?> cls, @MachineSizedUInt long value, long flags) {
            return AsLongMarshaler.toObject(cls, value, flags);
        }

        @MarshalsValue
        @MachineSizedUInt
        public static long toNative(Bits<?> o, long flags) {
            return ((Bits)o).value;
        }
    }

    public static class AsLongMarshaler {
        @MarshalsValue
        public static Bits<?> toObject(Class<?> cls, long value, long flags) {
            Bits f = (Bits)VM.allocateObject(cls);
            f.value = value;
            f.mask = f.value == 0L ? -1L : f.value;
            return f;
        }

        @MarshalsValue
        public static long toNative(Bits<?> o, long flags) {
            return ((Bits)o).value;
        }
    }

    public static class AsIntMarshaler {
        @MarshalsValue
        public static Bits<?> toObject(Class<?> cls, int value, long flags) {
            return AsLongMarshaler.toObject(cls, (long)value & 0xFFFFFFFFL, flags);
        }

        @MarshalsValue
        public static int toNative(Bits<?> o, long flags) {
            return (int)((Bits)o).value;
        }
    }

    public static class AsShortMarshaler {
        @MarshalsValue
        public static Bits<?> toObject(Class<?> cls, short value, long flags) {
            return AsLongMarshaler.toObject(cls, (long)value & 0xFFFFL, flags);
        }

        @MarshalsValue
        public static short toNative(Bits<?> o, long flags) {
            return (short)((Bits)o).value;
        }
    }

    public static class AsByteMarshaler {
        @MarshalsValue
        public static Bits<?> toObject(Class<?> cls, byte value, long flags) {
            return AsLongMarshaler.toObject(cls, (long)value & 0xFFL, flags);
        }

        @MarshalsValue
        public static byte toNative(Bits<?> o, long flags) {
            return (byte)((Bits)o).value;
        }
    }
}

