/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.rt.bro;

import com.bugvm.rt.VM;
import com.bugvm.rt.bro.Runtime;
import com.bugvm.rt.bro.annotation.Bridge;
import com.bugvm.rt.bro.annotation.GlobalValue;
import com.bugvm.rt.bro.annotation.Library;
import com.bugvm.rt.bro.ptr.VoidPtr;
import java.lang.reflect.Method;

public class Bro {
    public static final boolean IS_DARWIN;
    public static final boolean IS_IOS;
    public static final boolean IS_MACOSX;
    public static final boolean IS_LINUX;
    public static final boolean IS_X86;
    public static final boolean IS_ARM;
    public static final boolean IS_32BIT;
    public static final boolean IS_64BIT;

    public static void bind() {
        Bro.bind(VM.getStackClasses(0, 1)[0]);
    }

    public static void bind(Class<?> c) {
        Library library = c.getAnnotation(Library.class);
        if (library != null) {
            Runtime.loadLibrary(library);
        }
        for (Method method : c.getDeclaredMethods()) {
            long f;
            Bridge bridge = method.getAnnotation(Bridge.class);
            if (bridge != null && !bridge.dynamic() && !VM.isBridgeMethodBound(method)) {
                long f2 = Runtime.resolveBridge(library, bridge, method);
                if (f2 == 0L) continue;
                VM.bindBridgeMethod(method, f2);
                continue;
            }
            GlobalValue globalValue = method.getAnnotation(GlobalValue.class);
            if (globalValue == null || VM.isBridgeMethodBound(method) || (f = Runtime.resolveGlobalValue(library, globalValue, method)) == 0L) continue;
            VM.bindBridgeMethod(method, f);
        }
    }

    public static void addSearchPath(String path) {
        Runtime.addSearchPath(path);
    }

    static {
        String os = System.getProperty("os.name", "").toLowerCase();
        String arch = System.getProperty("os.arch", "").toLowerCase();
        IS_IOS = os.contains("ios");
        IS_MACOSX = !IS_IOS && os.contains("mac");
        IS_DARWIN = IS_IOS || IS_MACOSX;
        IS_LINUX = !IS_DARWIN && os.contains("linux");
        IS_X86 = arch.contains("x86");
        IS_ARM = !IS_X86 && (arch.contains("arm") || arch.contains("aarch64"));
        IS_64BIT = VoidPtr.sizeOf() == 8;
        IS_32BIT = !IS_64BIT;
    }
}

