/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.rt.bro;

import com.bugvm.rt.bro.annotation.MarshalsValue;

public class EnumMarshalers {

    public static class AsIntMarshaler {
        @MarshalsValue
        public static <T extends Enum<T>> T toObject(Class<T> cls, int ordinal, long flags) {
            Enum[] values2 = Enum.getSharedConstants(cls);
            if (values2.length == 0) {
                throw new AssertionError((Object)"Enum class has no values!");
            }
            if (ordinal < 0 || ordinal >= values2.length) {
                Class<?> enumType = values2[0].getClass();
                throw new IllegalArgumentException("No constant with ordinal " + ordinal + " in " + enumType.getName());
            }
            return (T)values2[ordinal];
        }

        @MarshalsValue
        public static int toNative(Enum<?> v, long flags) {
            return v.ordinal();
        }
    }
}

