/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.rt.bro.ptr;

import com.bugvm.rt.bro.Struct;
import com.bugvm.rt.bro.annotation.StructMember;
import com.bugvm.rt.bro.ptr.BytePtr;
import com.bugvm.rt.bro.ptr.Ptr;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public final class FloatPtr
extends Struct<FloatPtr> {
    public FloatPtr() {
    }

    public FloatPtr(float value) {
        this.set(value);
    }

    @StructMember(value=0)
    public native float get();

    @StructMember(value=0)
    public native void set(float var1);

    public FloatBuffer asFloatBuffer(int n) {
        return this.as(BytePtr.class).asByteBuffer(n << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    public float[] toFloatArray(int n) {
        float[] result = new float[n];
        this.get(result);
        return result;
    }

    public void get(float[] dst) {
        this.get(dst, 0, dst.length);
    }

    public void get(float[] dst, int offset, int count) {
        this.asFloatBuffer(count).get(dst, offset, count);
    }

    public void set(float[] src) {
        this.set(src, 0, src.length);
    }

    public void set(float[] src, int offset, int count) {
        this.asFloatBuffer(count).put(src, offset, count);
    }

    public static class FloatPtrPtr
    extends Ptr<FloatPtr, FloatPtrPtr> {
    }
}

