/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.sound;

import com.bugvm.sound.YDataLine;
import com.bugvm.sound.YNative;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;

public class YClip
extends YDataLine
implements Clip,
Runnable {
    byte[] data = null;
    int BufferSize = 1024;
    int LoopCount = 0;
    int LoopCounter = 0;
    Thread thread = null;
    int bufferLength = this.BufferSize;
    int ReadPos = 0;

    public YClip(Line.Info info) {
        super(info);
        if (Boolean.getBoolean("YDEBUG")) {
            System.out.println("returning from YClip(Line.Info info)");
        }
    }

    @Override
    public int getFrameLength() {
        return 0;
    }

    @Override
    public long getMicrosecondLength() {
        return 0L;
    }

    @Override
    public void loop(int count) {
        this.LoopCount = count;
    }

    @Override
    public void open(AudioFormat audioFormat, byte[] buffer, int offset, int bufferSize) throws LineUnavailableException {
        super.open();
        this.audioFormat = audioFormat;
        this.data = new byte[bufferSize];
        System.arraycopy((Object)buffer, offset, (Object)this.data, 0, bufferSize);
        int Encoding2 = 0;
        int FrameRate = (int)audioFormat.getFrameRate();
        int BitsPerSample = audioFormat.getSampleSizeInBits();
        int Channels2 = audioFormat.getChannels();
        int FrameSize = audioFormat.getFrameSize();
        int SampleRate = (int)audioFormat.getSampleRate();
        boolean isBigEndian = audioFormat.isBigEndian();
        this.BufferSize = 1024;
        int device = YNative.GetDefaultOutputDevice();
        YNative.OutputLineOpen(device, Encoding2, FrameRate, BitsPerSample, Channels2, FrameSize, SampleRate, isBigEndian, this.BufferSize);
    }

    @Override
    public void open(AudioInputStream stream) throws LineUnavailableException {
        int size = 5000000;
        byte[] buffer = new byte[size];
        int offset = 0;
        int bufferSize = buffer.length;
        try {
            stream.read(buffer, offset, bufferSize);
        }
        catch (IOException ex) {
            if (Boolean.getBoolean("YDEBUG")) {
                // empty if block
            }
        }
        this.open(stream.getFormat(), buffer, offset, bufferSize);
    }

    @Override
    public void start() {
        super.start();
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        super.stop();
    }

    @Override
    public void run() {
        while (this.thread != null) {
            byte[] buffer = new byte[this.bufferLength];
            this.read(buffer);
            YNative.write(buffer, 0, buffer.length);
        }
    }

    public void read(byte[] buffer) {
        int offset = 0;
        int length = buffer.length;
        if (this.ReadPos + length <= this.data.length) {
            System.arraycopy((Object)this.data, this.ReadPos, (Object)buffer, 0, length);
            this.ReadPos += length;
        } else {
            int soundBufferRemain = this.data.length - this.ReadPos;
            System.arraycopy((Object)this.data, this.ReadPos, (Object)buffer, offset, soundBufferRemain);
            int toGo = (length -= (offset += soundBufferRemain)) / this.data.length;
            int remain = length % this.data.length;
            if (toGo > 0) {
                for (int r = 0; r < toGo; ++r) {
                    System.arraycopy((Object)this.data, 0, (Object)buffer, offset, this.data.length);
                    offset += this.data.length;
                    this.ReadPos = 0;
                }
            }
            if (remain > 0) {
                System.arraycopy((Object)this.data, 0, (Object)buffer, offset, remain);
                offset += remain;
                this.ReadPos = remain;
            }
        }
    }

    @Override
    public void setFramePosition(int frames) {
    }

    @Override
    public void setLoopPoints(int start, int end) {
    }

    @Override
    public void setMicrosecondPosition(long microseconds) {
    }
}

