/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.sound;

import com.bugvm.sound.YNative;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

public class YLine
implements Line {
    Line.Info info;
    boolean isOpen = false;
    ConcurrentHashMap linelisteners = new ConcurrentHashMap();

    public YLine() {
    }

    public YLine(Line.Info info) {
        this.info = info;
        if (Boolean.getBoolean("YDEBUG")) {
            System.out.println("returning from YLine(Line.Info info)");
        }
    }

    @Override
    public Line.Info getLineInfo() {
        return this.info;
    }

    @Override
    public void open() throws LineUnavailableException {
        this.isOpen = true;
        YNative.Initialize();
        if (Boolean.getBoolean("YDEBUG")) {
            int devices = YNative.GetDeviceCount();
            System.out.println("GetDeviceCount " + devices);
            for (int i = 0; i < devices; ++i) {
                System.out.println("name: " + YNative.GetDeviceInfo(i));
            }
        }
        this.NotifiyListeners(LineEvent.Type.OPEN, 0L);
    }

    @Override
    public void close() {
        if (Boolean.getBoolean("YDEBUG")) {
            System.out.println("YLine.close()");
        }
        YNative.close();
        YNative.Terminate();
        this.isOpen = false;
        this.NotifiyListeners(LineEvent.Type.CLOSE, 0L);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public Control[] getControls() {
        return null;
    }

    @Override
    public boolean isControlSupported(Control.Type controlType) {
        return false;
    }

    @Override
    public Control getControl(Control.Type controlType) {
        return null;
    }

    @Override
    public void addLineListener(LineListener listener) {
        if (this.linelisteners.containsKey(listener)) {
            return;
        }
        this.linelisteners.put(listener, listener);
    }

    @Override
    public void removeLineListener(LineListener listener) {
        if (this.linelisteners.containsKey(listener)) {
            this.linelisteners.remove(listener);
        }
    }

    public void NotifiyListeners(LineEvent.Type type, long position) {
        if (!this.linelisteners.isEmpty()) {
            Enumeration e = this.linelisteners.elements();
            while (e.hasMoreElements()) {
                LineListener listener = (LineListener)e.nextElement();
                LineEvent event = new LineEvent(this, type, position);
                listener.update(event);
            }
        }
    }
}

