/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.sound;

import com.bugvm.sound.YDataLine;
import com.bugvm.sound.YNative;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Port;

public class YPort
extends YDataLine
implements Port {
    public YPort() {
    }

    public YPort(Port.Info info) {
        super(info);
        this.info = info;
    }

    public void open(int device, AudioFormat audioFormat, int BufferSize) throws LineUnavailableException {
        super.open();
        this.audioFormat = audioFormat;
        int Encoding2 = 0;
        int FrameRate = (int)audioFormat.getFrameRate();
        int BitsPerSample = audioFormat.getSampleSizeInBits();
        int Channels2 = audioFormat.getChannels();
        int FrameSize = audioFormat.getFrameSize();
        int SampleRate = (int)audioFormat.getSampleRate();
        boolean isBigEndian = audioFormat.isBigEndian();
        YNative.InputLineOpen(device, Encoding2, FrameRate, BitsPerSample, Channels2, FrameSize, SampleRate, isBigEndian, BufferSize);
    }

    public void open(Port.Info info, AudioFormat audioFormat, int BufferSize) throws LineUnavailableException {
        if (Boolean.getBoolean("YDEBUG")) {
            System.out.println("YPort open(Port.Info info, AudioFormat audioFormat, int BufferSize)");
        }
        super.open();
        this.audioFormat = audioFormat;
        int device = 0;
        int Encoding2 = 0;
        int FrameRate = (int)audioFormat.getFrameRate();
        int BitsPerSample = audioFormat.getSampleSizeInBits();
        int Channels2 = audioFormat.getChannels();
        int FrameSize = audioFormat.getFrameSize();
        int SampleRate = (int)audioFormat.getSampleRate();
        boolean isBigEndian = audioFormat.isBigEndian();
        if (info == Port.Info.COMPACT_DISC) {
            device = 0;
            YNative.InputLineOpen(device, Encoding2, FrameRate, BitsPerSample, Channels2, FrameSize, SampleRate, isBigEndian, BufferSize);
            return;
        }
        if (info == Port.Info.HEADPHONE) {
            device = 2;
            YNative.OutputLineOpen(device, Encoding2, FrameRate, BitsPerSample, Channels2, FrameSize, SampleRate, isBigEndian, BufferSize);
            return;
        }
        if (info == Port.Info.LINE_IN) {
            device = 1;
            YNative.InputLineOpen(device, Encoding2, FrameRate, BitsPerSample, Channels2, FrameSize, SampleRate, isBigEndian, BufferSize);
            return;
        }
        if (info == Port.Info.LINE_OUT) {
            device = 2;
            YNative.OutputLineOpen(device, Encoding2, FrameRate, BitsPerSample, Channels2, FrameSize, SampleRate, isBigEndian, BufferSize);
            return;
        }
        if (info == Port.Info.MICROPHONE) {
            device = 0;
            YNative.InputLineOpen(device, Encoding2, FrameRate, BitsPerSample, Channels2, FrameSize, SampleRate, isBigEndian, BufferSize);
            return;
        }
        if (info == Port.Info.SPEAKER) {
            device = 2;
            YNative.OutputLineOpen(device, Encoding2, FrameRate, BitsPerSample, Channels2, FrameSize, SampleRate, isBigEndian, BufferSize);
            return;
        }
    }
}

