/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.websocket;

import com.bugvm.websocket.WebSocket;
import com.bugvm.websocket.WebSocketListener;
import com.bugvm.websocket.drafts.Draft;
import com.bugvm.websocket.exceptions.InvalidDataException;
import com.bugvm.websocket.exceptions.InvalidHandshakeException;
import com.bugvm.websocket.framing.Framedata;
import com.bugvm.websocket.framing.PingFrame;
import com.bugvm.websocket.framing.PongFrame;
import com.bugvm.websocket.handshake.ClientHandshake;
import com.bugvm.websocket.handshake.HandshakeImpl1Server;
import com.bugvm.websocket.handshake.ServerHandshake;
import com.bugvm.websocket.handshake.ServerHandshakeBuilder;
import java.net.InetSocketAddress;

public abstract class WebSocketAdapter
implements WebSocketListener {
    @Override
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket conn, Draft draft, ClientHandshake request) throws InvalidDataException {
        return new HandshakeImpl1Server();
    }

    @Override
    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
    }

    @Override
    public void onWebsocketHandshakeSentAsClient(WebSocket conn, ClientHandshake request) throws InvalidDataException {
    }

    @Override
    public void onWebsocketMessageFragment(WebSocket conn, Framedata frame) {
    }

    @Override
    public void onWebsocketPing(WebSocket conn, Framedata f) {
        conn.sendFrame(new PongFrame((PingFrame)f));
    }

    @Override
    public void onWebsocketPong(WebSocket conn, Framedata f) {
    }

    @Override
    public String getFlashPolicy(WebSocket conn) throws InvalidDataException {
        InetSocketAddress adr = conn.getLocalSocketAddress();
        if (null == adr) {
            throw new InvalidHandshakeException("socket not bound");
        }
        return "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"" + adr.getPort() + "\" /></cross-domain-policy>\u0000";
    }
}

