/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class Boolean
implements Serializable,
Comparable<Boolean> {
    private static final long serialVersionUID = -3665804199014368530L;
    private final boolean value;
    public static final Class<Boolean> TYPE = boolean[].class.getComponentType();
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);

    public Boolean(String string) {
        this(Boolean.parseBoolean(string));
    }

    public Boolean(boolean value) {
        this.value = value;
    }

    public boolean booleanValue() {
        return this.value;
    }

    @FindBugsSuppressWarnings(value={"RC_REF_COMPARISON_BAD_PRACTICE_BOOLEAN"})
    public boolean equals(Object o) {
        return o == this || o instanceof Boolean && ((Boolean)o).value == this.value;
    }

    @Override
    public int compareTo(Boolean that) {
        return Boolean.compare(this.value, that.value);
    }

    public static int compare(boolean lhs, boolean rhs) {
        return lhs == rhs ? 0 : (lhs ? 1 : -1);
    }

    public int hashCode() {
        return this.value ? 1231 : 1237;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static boolean getBoolean(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(System.getProperty(string));
    }

    public static boolean parseBoolean(String s) {
        return "true".equalsIgnoreCase(s);
    }

    public static String toString(boolean value) {
        return String.valueOf(value);
    }

    public static Boolean valueOf(String string) {
        return Boolean.parseBoolean(string) ? TRUE : FALSE;
    }

    public static Boolean valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }
}

