/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;
import java.nio.IoVec;
import java.nio.MappedByteBuffer;
import java.nio.MemoryBlock;
import java.nio.NioUtils;
import java.nio.SocketChannelImpl;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import libcore.io.StructFlock;
import libcore.util.MutableLong;

final class FileChannelImpl
extends FileChannel {
    private static final Comparator<FileLock> LOCK_COMPARATOR = new Comparator<FileLock>(){

        @Override
        public int compare(FileLock lock1, FileLock lock2) {
            long position2;
            long position1 = lock1.position();
            return position1 > (position2 = lock2.position()) ? 1 : (position1 < position2 ? -1 : 0);
        }
    };
    private final Object stream;
    private final FileDescriptor fd;
    private final int mode;
    private final SortedSet<FileLock> locks = new TreeSet<FileLock>(LOCK_COMPARATOR);

    public FileChannelImpl(Object stream, FileDescriptor fd, int mode) {
        this.fd = fd;
        this.stream = stream;
        this.mode = mode;
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private void checkReadable() {
        if ((this.mode & OsConstants.O_ACCMODE) == OsConstants.O_WRONLY) {
            throw new NonReadableChannelException();
        }
    }

    private void checkWritable() {
        if ((this.mode & OsConstants.O_ACCMODE) == OsConstants.O_RDONLY) {
            throw new NonWritableChannelException();
        }
    }

    @Override
    protected void implCloseChannel() throws IOException {
        if (this.stream instanceof Closeable) {
            ((Closeable)this.stream).close();
        }
    }

    private FileLock basicLock(long position, long size, boolean shared, boolean wait) throws IOException {
        int accessMode = this.mode & OsConstants.O_ACCMODE;
        if (accessMode == OsConstants.O_RDONLY) {
            if (!shared) {
                throw new NonWritableChannelException();
            }
        } else if (accessMode == OsConstants.O_WRONLY && shared) {
            throw new NonReadableChannelException();
        }
        if (position < 0L || size < 0L) {
            throw new IllegalArgumentException("position=" + position + " size=" + size);
        }
        FileLockImpl pendingLock = new FileLockImpl(this, position, size, shared);
        this.addLock(pendingLock);
        StructFlock flock = new StructFlock();
        flock.l_type = (short)(shared ? OsConstants.F_RDLCK : OsConstants.F_WRLCK);
        flock.l_whence = (short)OsConstants.SEEK_SET;
        flock.l_start = position;
        flock.l_len = FileChannelImpl.translateLockLength(size);
        boolean success = false;
        try {
            success = Libcore.os.fcntlFlock(this.fd, wait ? OsConstants.F_SETLKW64 : OsConstants.F_SETLK64, flock) != -1;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
        finally {
            if (!success) {
                this.removeLock(pendingLock);
            }
        }
        return success ? pendingLock : null;
    }

    private static long translateLockLength(long byteCount) {
        return byteCount == Long.MAX_VALUE ? 0L : byteCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final FileLock lock(long position, long size, boolean shared) throws IOException {
        this.checkOpen();
        FileLock resultLock = null;
        boolean completed = false;
        try {
            this.begin();
            resultLock = this.basicLock(position, size, shared, true);
            completed = true;
        }
        finally {
            this.end(completed);
        }
        return resultLock;
    }

    @Override
    public final FileLock tryLock(long position, long size, boolean shared) throws IOException {
        this.checkOpen();
        return this.basicLock(position, size, shared, false);
    }

    public void release(FileLock lock) throws IOException {
        this.checkOpen();
        StructFlock flock = new StructFlock();
        flock.l_type = (short)OsConstants.F_UNLCK;
        flock.l_whence = (short)OsConstants.SEEK_SET;
        flock.l_start = lock.position();
        flock.l_len = FileChannelImpl.translateLockLength(lock.size());
        try {
            Libcore.os.fcntlFlock(this.fd, OsConstants.F_SETLKW64, flock);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
        this.removeLock(lock);
    }

    @Override
    public void force(boolean metadata) throws IOException {
        this.checkOpen();
        if ((this.mode & OsConstants.O_ACCMODE) != OsConstants.O_RDONLY) {
            try {
                if (metadata) {
                    Libcore.os.fsync(this.fd);
                } else {
                    Libcore.os.fdatasync(this.fd);
                }
            }
            catch (ErrnoException errnoException) {
                throw errnoException.rethrowAsIOException();
            }
        }
    }

    @Override
    public final MappedByteBuffer map(FileChannel.MapMode mapMode, long position, long size) throws IOException {
        this.checkOpen();
        if (mapMode == null) {
            throw new NullPointerException("mapMode == null");
        }
        if (position < 0L || size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position=" + position + " size=" + size);
        }
        int accessMode = this.mode & OsConstants.O_ACCMODE;
        if (accessMode == OsConstants.O_RDONLY) {
            if (mapMode != FileChannel.MapMode.READ_ONLY) {
                throw new NonWritableChannelException();
            }
        } else if (accessMode == OsConstants.O_WRONLY) {
            throw new NonReadableChannelException();
        }
        if (position + size > this.size()) {
            try {
                Libcore.os.ftruncate(this.fd, position + size);
            }
            catch (ErrnoException ftruncateException) {
                try {
                    if (OsConstants.S_ISREG(Libcore.os.fstat((FileDescriptor)this.fd).st_mode) || ftruncateException.errno != OsConstants.EINVAL) {
                        throw ftruncateException.rethrowAsIOException();
                    }
                }
                catch (ErrnoException fstatException) {
                    throw fstatException.rethrowAsIOException();
                }
            }
        }
        long alignment = position - position % Libcore.os.sysconf(OsConstants._SC_PAGE_SIZE);
        int offset = (int)(position - alignment);
        MemoryBlock block = MemoryBlock.mmap(this.fd, alignment, size + (long)offset, mapMode);
        return new DirectByteBuffer(block, (int)size, offset, mapMode == FileChannel.MapMode.READ_ONLY, mapMode);
    }

    @Override
    public long position() throws IOException {
        this.checkOpen();
        try {
            return Libcore.os.lseek(this.fd, 0L, OsConstants.SEEK_CUR);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        this.checkOpen();
        if (newPosition < 0L) {
            throw new IllegalArgumentException("position: " + newPosition);
        }
        try {
            Libcore.os.lseek(this.fd, newPosition, OsConstants.SEEK_SET);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
        return this;
    }

    @Override
    public int read(ByteBuffer buffer, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position: " + position);
        }
        return this.readImpl(buffer, position);
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        return this.readImpl(buffer, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readImpl(ByteBuffer buffer, long position) throws IOException {
        buffer.checkWritable();
        this.checkOpen();
        this.checkReadable();
        if (!buffer.hasRemaining()) {
            return 0;
        }
        int bytesRead = 0;
        boolean completed = false;
        try {
            this.begin();
            try {
                bytesRead = position == -1L ? Libcore.os.read(this.fd, buffer) : Libcore.os.pread(this.fd, buffer, position);
                if (bytesRead == 0) {
                    bytesRead = -1;
                }
            }
            catch (ErrnoException errnoException) {
                if (errnoException.errno == OsConstants.EAGAIN) {
                    bytesRead = 0;
                }
                throw errnoException.rethrowAsIOException();
            }
            completed = true;
            this.end(completed && bytesRead >= 0);
        }
        catch (Throwable throwable) {
            this.end(completed && bytesRead >= 0);
            throw throwable;
        }
        if (bytesRead > 0) {
            buffer.position(buffer.position() + bytesRead);
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transferIoVec(IoVec ioVec) throws IOException {
        if (ioVec.init() == 0) {
            return 0;
        }
        int bytesTransferred = 0;
        boolean completed = false;
        try {
            this.begin();
            bytesTransferred = ioVec.doTransfer(this.fd);
            completed = true;
        }
        finally {
            this.end(completed);
        }
        ioVec.didTransfer(bytesTransferred);
        return bytesTransferred;
    }

    @Override
    public long read(ByteBuffer[] buffers, int offset, int length) throws IOException {
        Arrays.checkOffsetAndCount(buffers.length, offset, length);
        this.checkOpen();
        this.checkReadable();
        return this.transferIoVec(new IoVec(buffers, offset, length, IoVec.Direction.READV));
    }

    @Override
    public long size() throws IOException {
        this.checkOpen();
        try {
            return Libcore.os.fstat((FileDescriptor)this.fd).st_size;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        this.checkOpen();
        if (!src.isOpen()) {
            throw new ClosedChannelException();
        }
        this.checkWritable();
        if (position < 0L || count < 0L || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position=" + position + " count=" + count);
        }
        if (position > this.size()) {
            return 0L;
        }
        if (src instanceof FileChannel) {
            FileChannel fileSrc = (FileChannel)src;
            long size = fileSrc.size();
            long filePosition = fileSrc.position();
            count = Math.min(count, size - filePosition);
            MappedByteBuffer buffer = fileSrc.map(FileChannel.MapMode.READ_ONLY, filePosition, count);
            try {
                fileSrc.position(filePosition + count);
                long l = this.write(buffer, position);
                return l;
            }
            finally {
                NioUtils.freeDirectBuffer(buffer);
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)count);
        src.read(buffer);
        buffer.flip();
        return this.write(buffer, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        long l;
        this.checkOpen();
        if (!target.isOpen()) {
            throw new ClosedChannelException();
        }
        this.checkReadable();
        if (target instanceof FileChannelImpl) {
            ((FileChannelImpl)target).checkWritable();
        }
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException("position=" + position + " count=" + count);
        }
        if (count == 0L || position >= this.size()) {
            return 0L;
        }
        count = Math.min(count, this.size() - position);
        boolean completed = false;
        if (target instanceof SocketChannelImpl) {
            FileDescriptor outFd = ((SocketChannelImpl)target).getFD();
            this.begin();
            MutableLong offset = new MutableLong(position);
            long rc = Libcore.os.sendfile(outFd, this.fd, offset, count);
            completed = true;
            long l2 = rc;
            this.end(completed);
            return l2;
            {
                catch (ErrnoException errnoException) {
                    try {
                        if (errnoException.errno != OsConstants.ENOSYS && errnoException.errno != OsConstants.EINVAL) {
                            throw errnoException.rethrowAsIOException();
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.end(completed);
                    }
                }
            }
        }
        MappedByteBuffer buffer = null;
        try {
            buffer = this.map(FileChannel.MapMode.READ_ONLY, position, count);
            l = target.write(buffer);
        }
        catch (Throwable throwable) {
            NioUtils.freeDirectBuffer(buffer);
            throw throwable;
        }
        NioUtils.freeDirectBuffer(buffer);
        return l;
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        this.checkOpen();
        if (size < 0L) {
            throw new IllegalArgumentException("size < 0: " + size);
        }
        this.checkWritable();
        if (size < this.size()) {
            try {
                Libcore.os.ftruncate(this.fd, size);
            }
            catch (ErrnoException errnoException) {
                throw errnoException.rethrowAsIOException();
            }
        }
        return this;
    }

    @Override
    public int write(ByteBuffer buffer, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position < 0: " + position);
        }
        return this.writeImpl(buffer, position);
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        return this.writeImpl(buffer, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeImpl(ByteBuffer buffer, long position) throws IOException {
        this.checkOpen();
        this.checkWritable();
        if (buffer == null) {
            throw new NullPointerException("buffer == null");
        }
        if (!buffer.hasRemaining()) {
            return 0;
        }
        int bytesWritten = 0;
        boolean completed = false;
        try {
            this.begin();
            try {
                bytesWritten = position == -1L ? Libcore.os.write(this.fd, buffer) : Libcore.os.pwrite(this.fd, buffer, position);
            }
            catch (ErrnoException errnoException) {
                throw errnoException.rethrowAsIOException();
            }
            completed = true;
        }
        finally {
            this.end(completed);
        }
        if (bytesWritten > 0) {
            buffer.position(buffer.position() + bytesWritten);
        }
        return bytesWritten;
    }

    @Override
    public long write(ByteBuffer[] buffers, int offset, int length) throws IOException {
        Arrays.checkOffsetAndCount(buffers.length, offset, length);
        this.checkOpen();
        this.checkWritable();
        return this.transferIoVec(new IoVec(buffers, offset, length, IoVec.Direction.WRITEV));
    }

    static int calculateTotalRemaining(ByteBuffer[] buffers, int offset, int length, boolean copyingIn) {
        int count = 0;
        for (int i = offset; i < offset + length; ++i) {
            count += buffers[i].remaining();
            if (!copyingIn) continue;
            buffers[i].checkWritable();
        }
        return count;
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    private synchronized void addLock(FileLock lock) throws OverlappingFileLockException {
        FileLock existingLock;
        long lockEnd = lock.position() + lock.size();
        Iterator iterator2 = this.locks.iterator();
        while (iterator2.hasNext() && (existingLock = (FileLock)iterator2.next()).position() <= lockEnd) {
            if (!existingLock.overlaps(lock.position(), lock.size())) continue;
            throw new OverlappingFileLockException();
        }
        this.locks.add(lock);
    }

    private synchronized void removeLock(FileLock lock) {
        this.locks.remove(lock);
    }

    private static final class FileLockImpl
    extends FileLock {
        private boolean isReleased = false;

        public FileLockImpl(FileChannel channel, long position, long size, boolean shared) {
            super(channel, position, size, shared);
        }

        @Override
        public boolean isValid() {
            return !this.isReleased && this.channel().isOpen();
        }

        @Override
        public void release() throws IOException {
            if (!this.channel().isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isReleased) {
                ((FileChannelImpl)this.channel()).release(this);
                this.isReleased = true;
            }
        }
    }
}

