/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import libcore.util.Objects;

public class TreeMap<K, V>
extends AbstractMap<K, V>
implements SortedMap<K, V>,
NavigableMap<K, V>,
Cloneable,
Serializable {
    private static final Comparator<Comparable> NATURAL_ORDER = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable a, Comparable b) {
            return a.compareTo(b);
        }
    };
    Comparator<? super K> comparator;
    Node<K, V> root;
    int size = 0;
    int modCount = 0;
    private EntrySet entrySet;
    private KeySet keySet;
    private static final long serialVersionUID = 919286545866124006L;

    public TreeMap() {
        this.comparator = NATURAL_ORDER;
    }

    public TreeMap(Map<? extends K, ? extends V> copyFrom) {
        this();
        for (Map.Entry<K, V> entry : copyFrom.entrySet()) {
            this.putInternal(entry.getKey(), entry.getValue());
        }
    }

    public TreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator != null ? comparator : NATURAL_ORDER;
    }

    public TreeMap(SortedMap<K, ? extends V> copyFrom) {
        Comparator<K> sourceComparator = copyFrom.comparator();
        this.comparator = sourceComparator != null ? sourceComparator : NATURAL_ORDER;
        for (Map.Entry entry : copyFrom.entrySet()) {
            this.putInternal(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object clone() {
        try {
            TreeMap map = (TreeMap)super.clone();
            map.root = this.root != null ? this.root.copy(null) : null;
            map.entrySet = null;
            map.keySet = null;
            return map;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key) {
        Node<K, V> entry = this.findByObject(key);
        return entry != null ? (V)entry.getValue() : null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findByObject(key) != null;
    }

    @Override
    public V put(K key, V value) {
        return this.putInternal(key, value);
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public V remove(Object key) {
        Node<K, V> node = this.removeInternalByKey(key);
        return node != null ? (V)node.value : null;
    }

    V putInternal(K key, V value) {
        Node<K, V> created = this.find(key, Relation.CREATE);
        Object result = created.value;
        created.value = value;
        return result;
    }

    Node<K, V> find(K key, Relation relation) {
        if (this.root == null) {
            if (this.comparator == NATURAL_ORDER && !(key instanceof Comparable)) {
                throw new ClassCastException(key.getClass().getName() + " is not Comparable");
            }
            if (relation == Relation.CREATE) {
                this.root = new Node(null, key);
                this.size = 1;
                ++this.modCount;
                return this.root;
            }
            return null;
        }
        Comparable comparableKey = this.comparator == NATURAL_ORDER ? (Comparable)key : null;
        Node<K, V> nearest = this.root;
        while (true) {
            Node child;
            int comparison;
            int n = comparison = comparableKey != null ? comparableKey.compareTo(nearest.key) : this.comparator.compare(key, nearest.key);
            if (comparison == 0) {
                switch (relation) {
                    case LOWER: {
                        return nearest.prev();
                    }
                    case FLOOR: 
                    case EQUAL: 
                    case CEILING: 
                    case CREATE: {
                        return nearest;
                    }
                    case HIGHER: {
                        return nearest.next();
                    }
                }
            }
            Node node = child = comparison < 0 ? nearest.left : nearest.right;
            if (child != null) {
                nearest = child;
                continue;
            }
            if (comparison < 0) {
                switch (relation) {
                    case LOWER: 
                    case FLOOR: {
                        return nearest.prev();
                    }
                    case CEILING: 
                    case HIGHER: {
                        return nearest;
                    }
                    case EQUAL: {
                        return null;
                    }
                    case CREATE: {
                        Node<K, V> created = new Node<K, V>(nearest, key);
                        nearest.left = created;
                        ++this.size;
                        ++this.modCount;
                        this.rebalance(nearest, true);
                        return created;
                    }
                }
                continue;
            }
            switch (relation) {
                case LOWER: 
                case FLOOR: {
                    return nearest;
                }
                case CEILING: 
                case HIGHER: {
                    return nearest.next();
                }
                case EQUAL: {
                    return null;
                }
                case CREATE: {
                    Node<K, V> created = new Node<K, V>(nearest, key);
                    nearest.right = created;
                    ++this.size;
                    ++this.modCount;
                    this.rebalance(nearest, true);
                    return created;
                }
            }
        }
    }

    Node<K, V> findByObject(Object key) {
        return this.find(key, Relation.EQUAL);
    }

    Node<K, V> findByEntry(Map.Entry<?, ?> entry) {
        Node<K, V> mine = this.findByObject(entry.getKey());
        boolean valuesEqual = mine != null && Objects.equal(mine.value, entry.getValue());
        return valuesEqual ? mine : null;
    }

    void removeInternal(Node<K, V> node) {
        Node left = node.left;
        Node right = node.right;
        Node originalParent = node.parent;
        if (left != null && right != null) {
            Node adjacent = left.height > right.height ? left.last() : right.first();
            this.removeInternal(adjacent);
            int leftHeight = 0;
            left = node.left;
            if (left != null) {
                leftHeight = left.height;
                adjacent.left = left;
                left.parent = adjacent;
                node.left = null;
            }
            int rightHeight = 0;
            right = node.right;
            if (right != null) {
                rightHeight = right.height;
                adjacent.right = right;
                right.parent = adjacent;
                node.right = null;
            }
            adjacent.height = Math.max(leftHeight, rightHeight) + 1;
            this.replaceInParent(node, adjacent);
            return;
        }
        if (left != null) {
            this.replaceInParent(node, left);
            node.left = null;
        } else if (right != null) {
            this.replaceInParent(node, right);
            node.right = null;
        } else {
            this.replaceInParent(node, null);
        }
        this.rebalance(originalParent, false);
        --this.size;
        ++this.modCount;
    }

    Node<K, V> removeInternalByKey(Object key) {
        Node<K, V> node = this.findByObject(key);
        if (node != null) {
            this.removeInternal(node);
        }
        return node;
    }

    private void replaceInParent(Node<K, V> node, Node<K, V> replacement) {
        Node parent = node.parent;
        node.parent = null;
        if (replacement != null) {
            replacement.parent = parent;
        }
        if (parent != null) {
            if (parent.left == node) {
                parent.left = replacement;
            } else {
                parent.right = replacement;
            }
        } else {
            this.root = replacement;
        }
    }

    private void rebalance(Node<K, V> unbalanced, boolean insert) {
        Node<K, V> node = unbalanced;
        while (node != null) {
            Node right;
            int rightHeight;
            Node left = node.left;
            int leftHeight = left != null ? left.height : 0;
            int delta = leftHeight - (rightHeight = (right = node.right) != null ? right.height : 0);
            if (delta == -2) {
                Node rightRight;
                int rightRightHeight;
                Node rightLeft = right.left;
                int rightLeftHeight = rightLeft != null ? rightLeft.height : 0;
                int rightDelta = rightLeftHeight - (rightRightHeight = (rightRight = right.right) != null ? rightRight.height : 0);
                if (rightDelta == -1 || rightDelta == 0 && !insert) {
                    this.rotateLeft(node);
                } else {
                    this.rotateRight(right);
                    this.rotateLeft(node);
                }
                if (insert) {
                    break;
                }
            } else if (delta == 2) {
                Node leftRight;
                int leftRightHeight;
                Node leftLeft = left.left;
                int leftLeftHeight = leftLeft != null ? leftLeft.height : 0;
                int leftDelta = leftLeftHeight - (leftRightHeight = (leftRight = left.right) != null ? leftRight.height : 0);
                if (leftDelta == 1 || leftDelta == 0 && !insert) {
                    this.rotateRight(node);
                } else {
                    this.rotateLeft(left);
                    this.rotateRight(node);
                }
                if (insert) {
                    break;
                }
            } else if (delta == 0) {
                node.height = leftHeight + 1;
                if (insert) {
                    break;
                }
            } else {
                node.height = Math.max(leftHeight, rightHeight) + 1;
                if (!insert) break;
            }
            node = node.parent;
        }
    }

    private void rotateLeft(Node<K, V> root) {
        Node left = root.left;
        Node pivot = root.right;
        Node pivotLeft = pivot.left;
        Node pivotRight = pivot.right;
        root.right = pivotLeft;
        if (pivotLeft != null) {
            pivotLeft.parent = root;
        }
        this.replaceInParent(root, pivot);
        pivot.left = root;
        root.parent = pivot;
        root.height = Math.max(left != null ? left.height : 0, pivotLeft != null ? pivotLeft.height : 0) + 1;
        pivot.height = Math.max(root.height, pivotRight != null ? pivotRight.height : 0) + 1;
    }

    private void rotateRight(Node<K, V> root) {
        Node pivot = root.left;
        Node right = root.right;
        Node pivotLeft = pivot.left;
        Node pivotRight = pivot.right;
        root.left = pivotRight;
        if (pivotRight != null) {
            pivotRight.parent = root;
        }
        this.replaceInParent(root, pivot);
        pivot.right = root;
        root.parent = pivot;
        root.height = Math.max(right != null ? right.height : 0, pivotRight != null ? pivotRight.height : 0) + 1;
        pivot.height = Math.max(root.height, pivotLeft != null ? pivotLeft.height : 0) + 1;
    }

    private AbstractMap.SimpleImmutableEntry<K, V> immutableCopy(Map.Entry<K, V> entry) {
        return entry == null ? null : new AbstractMap.SimpleImmutableEntry<K, V>(entry);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.immutableCopy(this.root == null ? null : this.root.first());
    }

    private Map.Entry<K, V> internalPollFirstEntry() {
        if (this.root == null) {
            return null;
        }
        Node<K, V> result = this.root.first();
        this.removeInternal(result);
        return result;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.immutableCopy(this.internalPollFirstEntry());
    }

    @Override
    public K firstKey() {
        if (this.root == null) {
            throw new NoSuchElementException();
        }
        return this.root.first().getKey();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.immutableCopy(this.root == null ? null : this.root.last());
    }

    private Map.Entry<K, V> internalPollLastEntry() {
        if (this.root == null) {
            return null;
        }
        Node<K, V> result = this.root.last();
        this.removeInternal(result);
        return result;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.immutableCopy(this.internalPollLastEntry());
    }

    @Override
    public K lastKey() {
        if (this.root == null) {
            throw new NoSuchElementException();
        }
        return this.root.last().getKey();
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.immutableCopy(this.find(key, Relation.LOWER));
    }

    @Override
    public K lowerKey(K key) {
        Node<K, V> entry = this.find(key, Relation.LOWER);
        return entry != null ? (K)entry.getKey() : null;
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.immutableCopy(this.find(key, Relation.FLOOR));
    }

    @Override
    public K floorKey(K key) {
        Node<K, V> entry = this.find(key, Relation.FLOOR);
        return entry != null ? (K)entry.getKey() : null;
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.immutableCopy(this.find(key, Relation.CEILING));
    }

    @Override
    public K ceilingKey(K key) {
        Node<K, V> entry = this.find(key, Relation.CEILING);
        return entry != null ? (K)entry.getKey() : null;
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.immutableCopy(this.find(key, Relation.HIGHER));
    }

    @Override
    public K higherKey(K key) {
        Node<K, V> entry = this.find(key, Relation.HIGHER);
        return entry != null ? (K)entry.getKey() : null;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator != NATURAL_ORDER ? this.comparator : null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet result = this.entrySet;
        return result != null ? result : (this.entrySet = new EntrySet());
    }

    @Override
    public Set<K> keySet() {
        KeySet result = this.keySet;
        return result != null ? result : (this.keySet = new KeySet());
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet result = this.keySet;
        return result != null ? result : (this.keySet = new KeySet());
    }

    @Override
    public NavigableMap<K, V> subMap(K from, boolean fromInclusive, K to, boolean toInclusive) {
        Bound fromBound = fromInclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
        Bound toBound = toInclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
        return new BoundedMap(true, from, fromBound, to, toBound);
    }

    @Override
    public SortedMap<K, V> subMap(K fromInclusive, K toExclusive) {
        return new BoundedMap(true, fromInclusive, Bound.INCLUSIVE, toExclusive, Bound.EXCLUSIVE);
    }

    @Override
    public NavigableMap<K, V> headMap(K to, boolean inclusive) {
        Bound toBound = inclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
        return new BoundedMap(true, null, Bound.NO_BOUND, to, toBound);
    }

    @Override
    public SortedMap<K, V> headMap(K toExclusive) {
        return new BoundedMap(true, null, Bound.NO_BOUND, toExclusive, Bound.EXCLUSIVE);
    }

    @Override
    public NavigableMap<K, V> tailMap(K from, boolean inclusive) {
        Bound fromBound = inclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
        return new BoundedMap(true, from, fromBound, null, Bound.NO_BOUND);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromInclusive) {
        return new BoundedMap(true, fromInclusive, Bound.INCLUSIVE, null, Bound.NO_BOUND);
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return new BoundedMap(false, null, Bound.NO_BOUND, null, Bound.NO_BOUND);
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return new BoundedMap(false, null, Bound.NO_BOUND, null, Bound.NO_BOUND).navigableKeySet();
    }

    static int count(Iterator<?> iterator2) {
        int count = 0;
        while (iterator2.hasNext()) {
            iterator2.next();
            ++count;
        }
        return count;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.putFields().put("comparator", this.comparator());
        stream.writeFields();
        stream.writeInt(this.size);
        for (Map.Entry<K, V> entry : this.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.comparator = (Comparator)fields.get("comparator", null);
        if (this.comparator == null) {
            this.comparator = NATURAL_ORDER;
        }
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            this.putInternal(stream.readObject(), stream.readObject());
        }
    }

    class SubMap
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        Object fromKey;
        Object toKey;
        boolean fromStart;
        boolean toEnd;

        SubMap() {
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            throw new UnsupportedOperationException();
        }

        protected Object readResolve() throws ObjectStreamException {
            Bound fromBound = this.fromStart ? Bound.NO_BOUND : Bound.INCLUSIVE;
            Bound toBound = this.toEnd ? Bound.NO_BOUND : Bound.EXCLUSIVE;
            return new BoundedMap(true, this.fromKey, fromBound, this.toKey, toBound);
        }
    }

    static class AscendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866124060L;

        AscendingSubMap(TreeMap<K, V> delegate, K from, Bound fromBound, K to, Bound toBound) {
            super(delegate, from, fromBound, to, toBound);
        }
    }

    static class DescendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866120460L;
        Comparator<K> reverseComparator;

        DescendingSubMap(TreeMap<K, V> delegate, K from, Bound fromBound, K to, Bound toBound) {
            super(delegate, from, fromBound, to, toBound);
        }
    }

    static abstract class NavigableSubMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -2102997345730753016L;
        TreeMap<K, V> m;
        Object lo;
        Object hi;
        boolean fromStart;
        boolean toEnd;
        boolean loInclusive;
        boolean hiInclusive;

        NavigableSubMap(TreeMap<K, V> delegate, K from, Bound fromBound, K to, Bound toBound) {
            this.m = delegate;
            this.lo = from;
            this.hi = to;
            this.fromStart = fromBound == Bound.NO_BOUND;
            this.toEnd = toBound == Bound.NO_BOUND;
            this.loInclusive = fromBound == Bound.INCLUSIVE;
            this.hiInclusive = toBound == Bound.INCLUSIVE;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            throw new UnsupportedOperationException();
        }

        protected Object readResolve() throws ObjectStreamException {
            Bound fromBound;
            Bound bound = this.fromStart ? Bound.NO_BOUND : (fromBound = this.loInclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE);
            Bound toBound = this.toEnd ? Bound.NO_BOUND : (this.hiInclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE);
            boolean ascending = !(this instanceof DescendingSubMap);
            TreeMap<K, V> treeMap = this.m;
            treeMap.getClass();
            return treeMap.new BoundedMap(ascending, this.lo, fromBound, this.hi, toBound);
        }
    }

    final class BoundedMap
    extends AbstractMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        private final transient boolean ascending;
        private final transient K from;
        private final transient Bound fromBound;
        private final transient K to;
        private final transient Bound toBound;
        private transient java.util.TreeMap$BoundedMap.BoundedEntrySet entrySet;
        private transient java.util.TreeMap$BoundedMap.BoundedKeySet keySet;

        BoundedMap(boolean ascending, K from, Bound fromBound, K to, Bound toBound) {
            if (fromBound != Bound.NO_BOUND && toBound != Bound.NO_BOUND) {
                if (TreeMap.this.comparator.compare(from, to) > 0) {
                    throw new IllegalArgumentException(from + " > " + to);
                }
            } else if (fromBound != Bound.NO_BOUND) {
                TreeMap.this.comparator.compare(from, from);
            } else if (toBound != Bound.NO_BOUND) {
                TreeMap.this.comparator.compare(to, to);
            }
            this.ascending = ascending;
            this.from = from;
            this.fromBound = fromBound;
            this.to = to;
            this.toBound = toBound;
        }

        @Override
        public int size() {
            return TreeMap.count(this.entrySet().iterator());
        }

        @Override
        public boolean isEmpty() {
            return this.endpoint(true) == null;
        }

        @Override
        public V get(Object key) {
            return this.isInBounds(key) ? (Object)TreeMap.this.get(key) : null;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.isInBounds(key) && TreeMap.this.containsKey(key);
        }

        @Override
        public V put(K key, V value) {
            if (!this.isInBounds(key)) {
                throw this.outOfBounds(key, this.fromBound, this.toBound);
            }
            return TreeMap.this.putInternal(key, value);
        }

        @Override
        public V remove(Object key) {
            return this.isInBounds(key) ? (Object)TreeMap.this.remove(key) : null;
        }

        private boolean isInBounds(Object key) {
            return this.isInBounds(key, this.fromBound, this.toBound);
        }

        private boolean isInBounds(K key, Bound fromBound, Bound toBound) {
            if (fromBound == Bound.INCLUSIVE ? TreeMap.this.comparator.compare(key, this.from) < 0 : fromBound == Bound.EXCLUSIVE && TreeMap.this.comparator.compare(key, this.from) <= 0) {
                return false;
            }
            return !(toBound == Bound.INCLUSIVE ? TreeMap.this.comparator.compare(key, this.to) > 0 : toBound == Bound.EXCLUSIVE && TreeMap.this.comparator.compare(key, this.to) >= 0);
        }

        private Node<K, V> bound(Node<K, V> node, Bound fromBound, Bound toBound) {
            return node != null && this.isInBounds(node.getKey(), fromBound, toBound) ? node : null;
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return TreeMap.this.immutableCopy(this.endpoint(true));
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Node result = this.endpoint(true);
            if (result != null) {
                TreeMap.this.removeInternal(result);
            }
            return TreeMap.this.immutableCopy(result);
        }

        @Override
        public K firstKey() {
            Node entry = this.endpoint(true);
            if (entry == null) {
                throw new NoSuchElementException();
            }
            return entry.getKey();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return TreeMap.this.immutableCopy(this.endpoint(false));
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Node result = this.endpoint(false);
            if (result != null) {
                TreeMap.this.removeInternal(result);
            }
            return TreeMap.this.immutableCopy(result);
        }

        @Override
        public K lastKey() {
            Node entry = this.endpoint(false);
            if (entry == null) {
                throw new NoSuchElementException();
            }
            return entry.getKey();
        }

        private Node<K, V> endpoint(boolean first) {
            Node node;
            if (this.ascending == first) {
                Node node2;
                switch (this.fromBound) {
                    case NO_BOUND: {
                        node2 = TreeMap.this.root == null ? null : TreeMap.this.root.first();
                        break;
                    }
                    case INCLUSIVE: {
                        node2 = TreeMap.this.find(this.from, Relation.CEILING);
                        break;
                    }
                    case EXCLUSIVE: {
                        node2 = TreeMap.this.find(this.from, Relation.HIGHER);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                return this.bound(node2, Bound.NO_BOUND, this.toBound);
            }
            switch (this.toBound) {
                case NO_BOUND: {
                    node = TreeMap.this.root == null ? null : TreeMap.this.root.last();
                    break;
                }
                case INCLUSIVE: {
                    node = TreeMap.this.find(this.to, Relation.FLOOR);
                    break;
                }
                case EXCLUSIVE: {
                    node = TreeMap.this.find(this.to, Relation.LOWER);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return this.bound(node, this.fromBound, Bound.NO_BOUND);
        }

        private Map.Entry<K, V> findBounded(K key, Relation relation) {
            int comparison;
            relation = relation.forOrder(this.ascending);
            Bound fromBoundForCheck = this.fromBound;
            Bound toBoundForCheck = this.toBound;
            if (this.toBound != Bound.NO_BOUND && (relation == Relation.LOWER || relation == Relation.FLOOR)) {
                comparison = TreeMap.this.comparator.compare(this.to, key);
                if (comparison <= 0) {
                    key = this.to;
                    if (this.toBound == Bound.EXCLUSIVE) {
                        relation = Relation.LOWER;
                    } else if (comparison < 0) {
                        relation = Relation.FLOOR;
                    }
                }
                toBoundForCheck = Bound.NO_BOUND;
            }
            if (this.fromBound != Bound.NO_BOUND && (relation == Relation.CEILING || relation == Relation.HIGHER)) {
                comparison = TreeMap.this.comparator.compare(this.from, key);
                if (comparison >= 0) {
                    key = this.from;
                    if (this.fromBound == Bound.EXCLUSIVE) {
                        relation = Relation.HIGHER;
                    } else if (comparison > 0) {
                        relation = Relation.CEILING;
                    }
                }
                fromBoundForCheck = Bound.NO_BOUND;
            }
            return this.bound(TreeMap.this.find(key, relation), fromBoundForCheck, toBoundForCheck);
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            return TreeMap.this.immutableCopy(this.findBounded(key, Relation.LOWER));
        }

        @Override
        public K lowerKey(K key) {
            Map.Entry entry = this.findBounded(key, Relation.LOWER);
            return entry != null ? (Object)entry.getKey() : null;
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            return TreeMap.this.immutableCopy(this.findBounded(key, Relation.FLOOR));
        }

        @Override
        public K floorKey(K key) {
            Map.Entry entry = this.findBounded(key, Relation.FLOOR);
            return entry != null ? (Object)entry.getKey() : null;
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            return TreeMap.this.immutableCopy(this.findBounded(key, Relation.CEILING));
        }

        @Override
        public K ceilingKey(K key) {
            Map.Entry entry = this.findBounded(key, Relation.CEILING);
            return entry != null ? (Object)entry.getKey() : null;
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            return TreeMap.this.immutableCopy(this.findBounded(key, Relation.HIGHER));
        }

        @Override
        public K higherKey(K key) {
            Map.Entry entry = this.findBounded(key, Relation.HIGHER);
            return entry != null ? (Object)entry.getKey() : null;
        }

        @Override
        public Comparator<? super K> comparator() {
            Comparator forward = TreeMap.this.comparator();
            if (this.ascending) {
                return forward;
            }
            return Collections.reverseOrder(forward);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            java.util.TreeMap$BoundedMap.BoundedEntrySet result = this.entrySet;
            return result != null ? result : (this.entrySet = new BoundedEntrySet());
        }

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            java.util.TreeMap$BoundedMap.BoundedKeySet result = this.keySet;
            return result != null ? result : (this.keySet = new BoundedKeySet());
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            return new BoundedMap(!this.ascending, this.from, this.fromBound, this.to, this.toBound);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return new BoundedMap(!this.ascending, this.from, this.fromBound, this.to, this.toBound).navigableKeySet();
        }

        @Override
        public NavigableMap<K, V> subMap(K from, boolean fromInclusive, K to, boolean toInclusive) {
            Bound fromBound = fromInclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
            Bound toBound = toInclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
            return this.subMap(from, fromBound, to, toBound);
        }

        @Override
        public NavigableMap<K, V> subMap(K fromInclusive, K toExclusive) {
            return this.subMap(fromInclusive, Bound.INCLUSIVE, toExclusive, Bound.EXCLUSIVE);
        }

        @Override
        public NavigableMap<K, V> headMap(K to, boolean inclusive) {
            Bound toBound = inclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
            return this.subMap(null, Bound.NO_BOUND, to, toBound);
        }

        @Override
        public NavigableMap<K, V> headMap(K toExclusive) {
            return this.subMap(null, Bound.NO_BOUND, toExclusive, Bound.EXCLUSIVE);
        }

        @Override
        public NavigableMap<K, V> tailMap(K from, boolean inclusive) {
            Bound fromBound = inclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
            return this.subMap(from, fromBound, null, Bound.NO_BOUND);
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromInclusive) {
            return this.subMap(fromInclusive, Bound.INCLUSIVE, null, Bound.NO_BOUND);
        }

        private NavigableMap<K, V> subMap(K from, Bound fromBound, K to, Bound toBound) {
            if (!this.ascending) {
                Object fromTmp = from;
                Bound fromBoundTmp = fromBound;
                from = to;
                fromBound = toBound;
                to = fromTmp;
                toBound = fromBoundTmp;
            }
            if (fromBound == Bound.NO_BOUND) {
                from = this.from;
                fromBound = this.fromBound;
            } else {
                Bound fromBoundToCheck;
                Bound bound = fromBoundToCheck = fromBound == this.fromBound ? Bound.INCLUSIVE : this.fromBound;
                if (!this.isInBounds(from, fromBoundToCheck, this.toBound)) {
                    throw this.outOfBounds(to, fromBoundToCheck, this.toBound);
                }
            }
            if (toBound == Bound.NO_BOUND) {
                to = this.to;
                toBound = this.toBound;
            } else {
                Bound toBoundToCheck;
                Bound bound = toBoundToCheck = toBound == this.toBound ? Bound.INCLUSIVE : this.toBound;
                if (!this.isInBounds(to, this.fromBound, toBoundToCheck)) {
                    throw this.outOfBounds(to, this.fromBound, toBoundToCheck);
                }
            }
            return new BoundedMap(this.ascending, from, fromBound, to, toBound);
        }

        private IllegalArgumentException outOfBounds(Object value, Bound fromBound, Bound toBound) {
            return new IllegalArgumentException(value + " not in range " + fromBound.leftCap(this.from) + ".." + toBound.rightCap(this.to));
        }

        Object writeReplace() throws ObjectStreamException {
            return this.ascending ? new AscendingSubMap(TreeMap.this, this.from, this.fromBound, this.to, this.toBound) : new DescendingSubMap(TreeMap.this, this.from, this.fromBound, this.to, this.toBound);
        }

        final class BoundedKeySet
        extends AbstractSet<K>
        implements NavigableSet<K> {
            BoundedKeySet() {
            }

            @Override
            public int size() {
                return BoundedMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return BoundedMap.this.isEmpty();
            }

            @Override
            public Iterator<K> iterator() {
                return new BoundedIterator(BoundedMap.this.endpoint(true)){

                    @Override
                    public K next() {
                        return (((BoundedMap)BoundedMap.this).ascending ? this.stepForward() : this.stepBackward()).key;
                    }
                };
            }

            @Override
            public Iterator<K> descendingIterator() {
                return new BoundedIterator(BoundedMap.this.endpoint(false)){

                    @Override
                    public K next() {
                        return (((BoundedMap)BoundedMap.this).ascending ? this.stepBackward() : this.stepForward()).key;
                    }
                };
            }

            @Override
            public boolean contains(Object key) {
                return BoundedMap.this.isInBounds(key) && TreeMap.this.findByObject(key) != null;
            }

            @Override
            public boolean remove(Object key) {
                return BoundedMap.this.isInBounds(key) && TreeMap.this.removeInternalByKey(key) != null;
            }

            @Override
            public K first() {
                return BoundedMap.this.firstKey();
            }

            @Override
            public K pollFirst() {
                Map.Entry entry = BoundedMap.this.pollFirstEntry();
                return entry != null ? (Object)entry.getKey() : null;
            }

            @Override
            public K last() {
                return BoundedMap.this.lastKey();
            }

            @Override
            public K pollLast() {
                Map.Entry entry = BoundedMap.this.pollLastEntry();
                return entry != null ? (Object)entry.getKey() : null;
            }

            @Override
            public K lower(K key) {
                return BoundedMap.this.lowerKey(key);
            }

            @Override
            public K floor(K key) {
                return BoundedMap.this.floorKey(key);
            }

            @Override
            public K ceiling(K key) {
                return BoundedMap.this.ceilingKey(key);
            }

            @Override
            public K higher(K key) {
                return BoundedMap.this.higherKey(key);
            }

            @Override
            public Comparator<? super K> comparator() {
                return BoundedMap.this.comparator();
            }

            @Override
            public NavigableSet<K> subSet(K from, boolean fromInclusive, K to, boolean toInclusive) {
                return BoundedMap.this.subMap(from, fromInclusive, to, toInclusive).navigableKeySet();
            }

            @Override
            public SortedSet<K> subSet(K fromInclusive, K toExclusive) {
                return BoundedMap.this.subMap(fromInclusive, toExclusive).navigableKeySet();
            }

            @Override
            public NavigableSet<K> headSet(K to, boolean inclusive) {
                return BoundedMap.this.headMap(to, inclusive).navigableKeySet();
            }

            @Override
            public SortedSet<K> headSet(K toExclusive) {
                return BoundedMap.this.headMap(toExclusive).navigableKeySet();
            }

            @Override
            public NavigableSet<K> tailSet(K from, boolean inclusive) {
                return BoundedMap.this.tailMap(from, inclusive).navigableKeySet();
            }

            @Override
            public SortedSet<K> tailSet(K fromInclusive) {
                return BoundedMap.this.tailMap(fromInclusive).navigableKeySet();
            }

            @Override
            public NavigableSet<K> descendingSet() {
                return new BoundedMap(!BoundedMap.this.ascending, BoundedMap.this.from, BoundedMap.this.fromBound, BoundedMap.this.to, BoundedMap.this.toBound).navigableKeySet();
            }
        }

        final class BoundedEntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            BoundedEntrySet() {
            }

            @Override
            public int size() {
                return BoundedMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return BoundedMap.this.isEmpty();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new BoundedIterator(BoundedMap.this.endpoint(true)){

                    @Override
                    public Map.Entry<K, V> next() {
                        return BoundedMap.this.ascending ? this.stepForward() : this.stepBackward();
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                return BoundedMap.this.isInBounds(entry.getKey()) && TreeMap.this.findByEntry(entry) != null;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                return BoundedMap.this.isInBounds(entry.getKey()) && TreeMap.this.entrySet().remove(entry);
            }
        }

        abstract class BoundedIterator<T>
        extends MapIterator<T> {
            protected BoundedIterator(Node<K, V> next) {
                super(next);
            }

            @Override
            protected Node<K, V> stepForward() {
                Node result = super.stepForward();
                if (this.next != null && !BoundedMap.this.isInBounds(this.next.key, Bound.NO_BOUND, BoundedMap.this.toBound)) {
                    this.next = null;
                }
                return result;
            }

            @Override
            protected Node<K, V> stepBackward() {
                Node result = super.stepBackward();
                if (this.next != null && !BoundedMap.this.isInBounds(this.next.key, BoundedMap.this.fromBound, Bound.NO_BOUND)) {
                    this.next = null;
                }
                return result;
            }
        }
    }

    static enum Bound {
        INCLUSIVE{

            @Override
            public String leftCap(Object from) {
                return "[" + from;
            }

            @Override
            public String rightCap(Object to) {
                return to + "]";
            }
        }
        ,
        EXCLUSIVE{

            @Override
            public String leftCap(Object from) {
                return "(" + from;
            }

            @Override
            public String rightCap(Object to) {
                return to + ")";
            }
        }
        ,
        NO_BOUND{

            @Override
            public String leftCap(Object from) {
                return ".";
            }

            @Override
            public String rightCap(Object to) {
                return ".";
            }
        };


        public abstract String leftCap(Object var1);

        public abstract String rightCap(Object var1);
    }

    class KeySet
    extends AbstractSet<K>
    implements NavigableSet<K> {
        KeySet() {
        }

        @Override
        public int size() {
            return TreeMap.this.size;
        }

        @Override
        public Iterator<K> iterator() {
            return new MapIterator<K>(TreeMap.this.root == null ? null : TreeMap.this.root.first()){

                @Override
                public K next() {
                    return this.stepForward().key;
                }
            };
        }

        @Override
        public Iterator<K> descendingIterator() {
            return new MapIterator<K>(TreeMap.this.root == null ? null : TreeMap.this.root.last()){

                @Override
                public K next() {
                    return this.stepBackward().key;
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return TreeMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object key) {
            return TreeMap.this.removeInternalByKey(key) != null;
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }

        @Override
        public Comparator<? super K> comparator() {
            return TreeMap.this.comparator();
        }

        @Override
        public K first() {
            return TreeMap.this.firstKey();
        }

        @Override
        public K last() {
            return TreeMap.this.lastKey();
        }

        @Override
        public K lower(K key) {
            return TreeMap.this.lowerKey(key);
        }

        @Override
        public K floor(K key) {
            return TreeMap.this.floorKey(key);
        }

        @Override
        public K ceiling(K key) {
            return TreeMap.this.ceilingKey(key);
        }

        @Override
        public K higher(K key) {
            return TreeMap.this.higherKey(key);
        }

        @Override
        public K pollFirst() {
            Map.Entry entry = TreeMap.this.internalPollFirstEntry();
            return entry != null ? (Object)entry.getKey() : null;
        }

        @Override
        public K pollLast() {
            Map.Entry entry = TreeMap.this.internalPollLastEntry();
            return entry != null ? (Object)entry.getKey() : null;
        }

        @Override
        public NavigableSet<K> subSet(K from, boolean fromInclusive, K to, boolean toInclusive) {
            return TreeMap.this.subMap(from, fromInclusive, to, toInclusive).navigableKeySet();
        }

        @Override
        public SortedSet<K> subSet(K fromInclusive, K toExclusive) {
            return TreeMap.this.subMap(fromInclusive, true, toExclusive, false).navigableKeySet();
        }

        @Override
        public NavigableSet<K> headSet(K to, boolean inclusive) {
            return TreeMap.this.headMap(to, inclusive).navigableKeySet();
        }

        @Override
        public SortedSet<K> headSet(K toExclusive) {
            return TreeMap.this.headMap(toExclusive, false).navigableKeySet();
        }

        @Override
        public NavigableSet<K> tailSet(K from, boolean inclusive) {
            return TreeMap.this.tailMap(from, inclusive).navigableKeySet();
        }

        @Override
        public SortedSet<K> tailSet(K fromInclusive) {
            return TreeMap.this.tailMap(fromInclusive, true).navigableKeySet();
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return new BoundedMap(false, null, Bound.NO_BOUND, null, Bound.NO_BOUND).navigableKeySet();
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return TreeMap.this.size;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MapIterator<Map.Entry<K, V>>(TreeMap.this.root == null ? null : TreeMap.this.root.first()){

                @Override
                public Map.Entry<K, V> next() {
                    return this.stepForward();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof Map.Entry && TreeMap.this.findByEntry((Map.Entry)o) != null;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Node node = TreeMap.this.findByEntry((Map.Entry)o);
            if (node == null) {
                return false;
            }
            TreeMap.this.removeInternal(node);
            return true;
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }
    }

    abstract class MapIterator<T>
    implements Iterator<T> {
        protected Node<K, V> next;
        protected Node<K, V> last;
        protected int expectedModCount;

        MapIterator(Node<K, V> next) {
            this.expectedModCount = TreeMap.this.modCount;
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        protected Node<K, V> stepForward() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.last = this.next;
            this.next = this.next.next();
            return this.last;
        }

        protected Node<K, V> stepBackward() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.last = this.next;
            this.next = this.next.prev();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            TreeMap.this.removeInternal(this.last);
            this.expectedModCount = TreeMap.this.modCount;
            this.last = null;
        }
    }

    static class Node<K, V>
    implements Map.Entry<K, V> {
        Node<K, V> parent;
        Node<K, V> left;
        Node<K, V> right;
        final K key;
        V value;
        int height;

        Node(Node<K, V> parent, K key) {
            this.parent = parent;
            this.key = key;
            this.height = 1;
        }

        Node<K, V> copy(Node<K, V> parent) {
            Node<K, V> result = new Node<K, V>(parent, this.key);
            if (this.left != null) {
                result.left = this.left.copy(result);
            }
            if (this.right != null) {
                result.right = this.right.copy(result);
            }
            result.value = this.value;
            result.height = this.height;
            return result;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry other = (Map.Entry)o;
                return (this.key == null ? other.getKey() == null : this.key.equals(other.getKey())) && (this.value == null ? other.getValue() == null : this.value.equals(other.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        Node<K, V> next() {
            if (this.right != null) {
                return this.right.first();
            }
            Node<K, V> node = this;
            Node<K, V> parent = node.parent;
            while (parent != null) {
                if (parent.left == node) {
                    return parent;
                }
                node = parent;
                parent = node.parent;
            }
            return null;
        }

        public Node<K, V> prev() {
            if (this.left != null) {
                return this.left.last();
            }
            Node<K, V> node = this;
            Node<K, V> parent = node.parent;
            while (parent != null) {
                if (parent.right == node) {
                    return parent;
                }
                node = parent;
                parent = node.parent;
            }
            return null;
        }

        public Node<K, V> first() {
            Node<K, V> node = this;
            Node<K, V> child = node.left;
            while (child != null) {
                node = child;
                child = node.left;
            }
            return node;
        }

        public Node<K, V> last() {
            Node<K, V> node = this;
            Node<K, V> child = node.right;
            while (child != null) {
                node = child;
                child = node.right;
            }
            return node;
        }
    }

    static enum Relation {
        LOWER,
        FLOOR,
        EQUAL,
        CREATE,
        CEILING,
        HIGHER;


        Relation forOrder(boolean ascending) {
            if (ascending) {
                return this;
            }
            switch (this) {
                case LOWER: {
                    return HIGHER;
                }
                case FLOOR: {
                    return CEILING;
                }
                case EQUAL: {
                    return EQUAL;
                }
                case CEILING: {
                    return FLOOR;
                }
                case HIGHER: {
                    return LOWER;
                }
            }
            throw new IllegalStateException();
        }
    }
}

