/*
 * Decompiled with CFR 0.152.
 */
package libcore.reflect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import libcore.reflect.AnnotationMember;

public final class AnnotationFactory
implements InvocationHandler,
Serializable {
    private static final transient Map<Class<? extends Annotation>, AnnotationMember[]> cache = new WeakHashMap<Class<? extends Annotation>, AnnotationMember[]>();
    private final Class<? extends Annotation> klazz;
    private AnnotationMember[] elements;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnnotationMember[] getElementsDescription(Class<? extends Annotation> annotationType) {
        AnnotationMember[] desc;
        Map<Class<? extends Annotation>, AnnotationMember[]> map = cache;
        synchronized (map) {
            desc = cache.get(annotationType);
            if (desc != null) {
                return desc;
            }
        }
        if (!annotationType.isAnnotation()) {
            throw new IllegalArgumentException("Type is not annotation: " + annotationType.getName());
        }
        Method[] declaredMethods = annotationType.getDeclaredMethods();
        desc = new AnnotationMember[declaredMethods.length];
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method element = declaredMethods[i];
            String name = element.getName();
            Class<?> type = element.getReturnType();
            try {
                desc[i] = new AnnotationMember(name, element.getDefaultValue(), type, element);
                continue;
            }
            catch (Throwable t) {
                desc[i] = new AnnotationMember(name, t, type, element);
            }
        }
        Map<Class<? extends Annotation>, AnnotationMember[]> map2 = cache;
        synchronized (map2) {
            cache.put(annotationType, desc);
        }
        return desc;
    }

    public static <A extends Annotation> A createAnnotation(Class<? extends Annotation> annotationType, AnnotationMember[] elements) {
        AnnotationFactory factory = new AnnotationFactory(annotationType, elements);
        return (A)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, factory));
    }

    private AnnotationFactory(Class<? extends Annotation> klzz, AnnotationMember[] values2) {
        this.klazz = klzz;
        AnnotationMember[] defs = AnnotationFactory.getElementsDescription(this.klazz);
        if (values2 == null) {
            this.elements = defs;
        } else {
            this.elements = new AnnotationMember[defs.length];
            block0: for (int i = this.elements.length - 1; i >= 0; --i) {
                for (AnnotationMember val : values2) {
                    if (!val.name.equals(defs[i].name)) continue;
                    this.elements[i] = val.setDefinition(defs[i]);
                    continue block0;
                }
                this.elements[i] = defs[i];
            }
        }
    }

    private void readObject(ObjectInputStream os) throws IOException, ClassNotFoundException {
        os.defaultReadObject();
        AnnotationMember[] defs = AnnotationFactory.getElementsDescription(this.klazz);
        AnnotationMember[] old = this.elements;
        ArrayList<AnnotationMember> merged = new ArrayList<AnnotationMember>(defs.length + old.length);
        block0: for (AnnotationMember el1 : old) {
            for (AnnotationMember el2 : defs) {
                if (el2.name.equals(el1.name)) continue block0;
            }
            merged.add(el1);
        }
        block2: for (AnnotationMember def : defs) {
            for (AnnotationMember val : old) {
                if (!val.name.equals(def.name)) continue;
                merged.add(val.setDefinition(def));
                continue block2;
            }
            merged.add(def);
        }
        this.elements = merged.toArray(new AnnotationMember[merged.size()]);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.klazz.isInstance(obj)) {
            return false;
        }
        InvocationHandler handler = null;
        if (Proxy.isProxyClass(obj.getClass()) && (handler = Proxy.getInvocationHandler(obj)) instanceof AnnotationFactory) {
            AnnotationFactory other = (AnnotationFactory)handler;
            if (this.elements.length != other.elements.length) {
                return false;
            }
            block2: for (AnnotationMember el1 : this.elements) {
                for (AnnotationMember el2 : other.elements) {
                    if (el1.equals(el2)) continue block2;
                }
                return false;
            }
            return true;
        }
        for (AnnotationMember el : this.elements) {
            if (el.tag == '!') {
                return false;
            }
            try {
                Object otherValue;
                if (!el.definingMethod.isAccessible()) {
                    el.definingMethod.setAccessible(true);
                }
                if (!((otherValue = el.definingMethod.invoke(obj, new Object[0])) != null ? (el.tag == '[' ? !el.equalArrayValue(otherValue) : !el.value.equals(otherValue)) : el.value != AnnotationMember.NO_VALUE)) continue;
                return false;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (AnnotationMember element : this.elements) {
            hash += element.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('@');
        result.append(this.klazz.getName());
        result.append('(');
        for (int i = 0; i < this.elements.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.elements[i]);
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        Class<?>[] params = method.getParameterTypes();
        if (params.length == 0) {
            if ("annotationType".equals(name)) {
                return this.klazz;
            }
            if ("toString".equals(name)) {
                return this.toString();
            }
            if ("hashCode".equals(name)) {
                return this.hashCode();
            }
            AnnotationMember element = null;
            for (AnnotationMember el : this.elements) {
                if (!name.equals(el.name)) continue;
                element = el;
                break;
            }
            if (element == null || !method.equals(element.definingMethod)) {
                throw new IllegalArgumentException(method.toString());
            }
            Object value = element.validateValue();
            if (value == null) {
                throw new IncompleteAnnotationException(this.klazz, name);
            }
            return value;
        }
        if (params.length == 1 && params[0] == Object.class && "equals".equals(name)) {
            return this.equals(args[0]);
        }
        throw new IllegalArgumentException("Invalid method for annotation type: " + method);
    }
}

