/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.apache.harmony.security.asn1.ASN1Constants;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;
import org.apache.harmony.security.asn1.DerInputStream;
import org.apache.harmony.security.asn1.DerOutputStream;

public abstract class ASN1Type
implements ASN1Constants {
    public final int id;
    public final int constrId;

    public ASN1Type(int tagNumber) {
        this(0, tagNumber);
    }

    public ASN1Type(int tagClass, int tagNumber) {
        if (tagNumber < 0) {
            throw new IllegalArgumentException("tagNumber < 0");
        }
        if (tagClass != 0 && tagClass != 64 && tagClass != 128 && tagClass != 192) {
            throw new IllegalArgumentException("invalid tagClass");
        }
        if (tagNumber >= 31) {
            throw new IllegalArgumentException("tag long form not implemented");
        }
        this.id = tagClass + tagNumber;
        this.constrId = this.id + 32;
    }

    public final Object decode(byte[] encoded) throws IOException {
        return this.decode(new DerInputStream(encoded));
    }

    public final Object decode(byte[] encoded, int offset, int encodingLen) throws IOException {
        return this.decode(new DerInputStream(encoded, offset, encodingLen));
    }

    public final Object decode(InputStream in) throws IOException {
        return this.decode(new DerInputStream(in));
    }

    public final void verify(byte[] encoded) throws IOException {
        DerInputStream decoder2 = new DerInputStream(encoded);
        decoder2.setVerify();
        this.decode(decoder2);
    }

    public final void verify(InputStream in) throws IOException {
        DerInputStream decoder2 = new DerInputStream(in);
        decoder2.setVerify();
        this.decode(decoder2);
    }

    public final byte[] encode(Object object) {
        DerOutputStream out = new DerOutputStream(this, object);
        return out.encoded;
    }

    public abstract Object decode(BerInputStream var1) throws IOException;

    public abstract boolean checkTag(int var1);

    protected Object getDecodedObject(BerInputStream in) throws IOException {
        return in.content;
    }

    public abstract void encodeASN(BerOutputStream var1);

    public abstract void encodeContent(BerOutputStream var1);

    public abstract void setEncodingContent(BerOutputStream var1);

    public int getEncodedLength(BerOutputStream out) {
        int len = 1;
        ++len;
        if (out.length > 127) {
            ++len;
            int cur = out.length >> 8;
            while (cur > 0) {
                cur >>= 8;
                ++len;
            }
        }
        return len += out.length;
    }

    public String toString() {
        return this.getClass().getName() + "(tag: 0x" + Integer.toHexString(0xFF & this.id) + ")";
    }
}

