/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1Explicit;
import org.apache.harmony.security.asn1.ASN1Implicit;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.x509.DistributionPointName;
import org.apache.harmony.security.x509.GeneralNames;
import org.apache.harmony.security.x509.ReasonFlags;

public final class DistributionPoint {
    private final DistributionPointName distributionPoint;
    private final ReasonFlags reasons;
    private final GeneralNames cRLIssuer;
    public static final ASN1Sequence ASN1 = new ASN1Sequence(new ASN1Type[]{new ASN1Explicit(0, DistributionPointName.ASN1), new ASN1Implicit(1, ReasonFlags.ASN1), new ASN1Implicit(2, GeneralNames.ASN1)}){
        {
            this.setOptional(0);
            this.setOptional(1);
            this.setOptional(2);
        }

        @Override
        protected Object getDecodedObject(BerInputStream in) throws IOException {
            Object[] values2 = (Object[])in.content;
            return new DistributionPoint((DistributionPointName)values2[0], (ReasonFlags)values2[1], (GeneralNames)values2[2]);
        }

        @Override
        protected void getValues(Object object, Object[] values2) {
            DistributionPoint dp = (DistributionPoint)object;
            values2[0] = dp.distributionPoint;
            values2[1] = dp.reasons;
            values2[2] = dp.cRLIssuer;
        }
    };

    public DistributionPoint(DistributionPointName distributionPoint, ReasonFlags reasons, GeneralNames cRLIssuer) {
        if (reasons != null && distributionPoint == null && cRLIssuer == null) {
            throw new IllegalArgumentException("DistributionPoint MUST NOT consist of only the reasons field");
        }
        this.distributionPoint = distributionPoint;
        this.reasons = reasons;
        this.cRLIssuer = cRLIssuer;
    }

    public void dumpValue(StringBuilder sb, String prefix) {
        sb.append(prefix);
        sb.append("Distribution Point: [\n");
        if (this.distributionPoint != null) {
            this.distributionPoint.dumpValue(sb, prefix + "  ");
        }
        if (this.reasons != null) {
            this.reasons.dumpValue(sb, prefix + "  ");
        }
        if (this.cRLIssuer != null) {
            sb.append(prefix);
            sb.append("  CRL Issuer: [\n");
            this.cRLIssuer.dumpValue(sb, prefix + "    ");
            sb.append(prefix);
            sb.append("  ]\n");
        }
        sb.append(prefix);
        sb.append("]\n");
    }
}

