/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.util.Date;
import org.apache.harmony.security.asn1.ASN1GeneralizedTime;
import org.apache.harmony.security.asn1.ASN1Implicit;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;

public final class PrivateKeyUsagePeriod {
    private final Date notBeforeDate;
    private final Date notAfterDate;
    private byte[] encoding;
    public static final ASN1Sequence ASN1 = new ASN1Sequence(new ASN1Type[]{new ASN1Implicit(0, ASN1GeneralizedTime.getInstance()), new ASN1Implicit(1, ASN1GeneralizedTime.getInstance())}){
        {
            this.setOptional(0);
            this.setOptional(1);
        }

        @Override
        protected Object getDecodedObject(BerInputStream in) {
            Object[] values2 = (Object[])in.content;
            return new PrivateKeyUsagePeriod((Date)values2[0], (Date)values2[1], in.getEncoded());
        }

        @Override
        protected void getValues(Object object, Object[] values2) {
            PrivateKeyUsagePeriod pkup = (PrivateKeyUsagePeriod)object;
            values2[0] = pkup.notBeforeDate;
            values2[1] = pkup.notAfterDate;
        }
    };

    public PrivateKeyUsagePeriod(Date notBeforeDate, Date notAfterDate) {
        this(notBeforeDate, notAfterDate, null);
    }

    private PrivateKeyUsagePeriod(Date notBeforeDate, Date notAfterDate, byte[] encoding) {
        this.notBeforeDate = notBeforeDate;
        this.notAfterDate = notAfterDate;
        this.encoding = encoding;
    }

    public Date getNotBefore() {
        return this.notBeforeDate;
    }

    public Date getNotAfter() {
        return this.notAfterDate;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this);
        }
        return this.encoding;
    }
}

