/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509.tsp;

import java.math.BigInteger;
import org.apache.harmony.security.asn1.ASN1Boolean;
import org.apache.harmony.security.asn1.ASN1Implicit;
import org.apache.harmony.security.asn1.ASN1Integer;
import org.apache.harmony.security.asn1.ASN1Oid;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.ObjectIdentifier;
import org.apache.harmony.security.x509.Extensions;
import org.apache.harmony.security.x509.tsp.MessageImprint;

public class TimeStampReq {
    private final int version;
    private final MessageImprint messageImprint;
    private final String reqPolicy;
    private final BigInteger nonce;
    private final Boolean certReq;
    private final Extensions extensions;
    private byte[] encoding;
    public static final ASN1Sequence ASN1 = new ASN1Sequence(new ASN1Type[]{ASN1Integer.getInstance(), MessageImprint.ASN1, ASN1Oid.getInstance(), ASN1Integer.getInstance(), ASN1Boolean.getInstance(), new ASN1Implicit(0, Extensions.ASN1)}){
        {
            this.setDefault(Boolean.FALSE, 4);
            this.setOptional(2);
            this.setOptional(3);
            this.setOptional(5);
        }

        @Override
        protected Object getDecodedObject(BerInputStream in) {
            BigInteger nonce;
            Object[] values2 = (Object[])in.content;
            String objID = values2[2] == null ? null : ObjectIdentifier.toString((int[])values2[2]);
            BigInteger bigInteger = nonce = values2[3] == null ? null : new BigInteger((byte[])values2[3]);
            if (values2[5] == null) {
                return new TimeStampReq(ASN1Integer.toIntValue(values2[0]), (MessageImprint)values2[1], objID, nonce, (Boolean)values2[4], null, in.getEncoded());
            }
            return new TimeStampReq(ASN1Integer.toIntValue(values2[0]), (MessageImprint)values2[1], objID, nonce, (Boolean)values2[4], (Extensions)values2[5], in.getEncoded());
        }

        @Override
        protected void getValues(Object object, Object[] values2) {
            TimeStampReq req = (TimeStampReq)object;
            values2[0] = ASN1Integer.fromIntValue(req.version);
            values2[1] = req.messageImprint;
            values2[2] = req.reqPolicy == null ? null : ObjectIdentifier.toIntArray(req.reqPolicy);
            values2[3] = req.nonce == null ? null : req.nonce.toByteArray();
            values2[4] = req.certReq == null ? Boolean.FALSE : req.certReq;
            values2[5] = req.extensions;
        }
    };

    public TimeStampReq(int version, MessageImprint messageImprint, String reqPolicy, BigInteger nonce, Boolean certReq, Extensions extensions) {
        this.version = version;
        this.messageImprint = messageImprint;
        this.reqPolicy = reqPolicy;
        this.nonce = nonce;
        this.certReq = certReq;
        this.extensions = extensions;
    }

    private TimeStampReq(int version, MessageImprint messageImprint, String reqPolicy, BigInteger nonce, Boolean certReq, Extensions extensions, byte[] encoding) {
        this(version, messageImprint, reqPolicy, nonce, certReq, extensions);
        this.encoding = encoding;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("-- TimeStampReq:");
        res.append("\nversion : ");
        res.append(this.version);
        res.append("\nmessageImprint:  ");
        res.append(this.messageImprint);
        res.append("\nreqPolicy:  ");
        res.append(this.reqPolicy);
        res.append("\nnonce:  ");
        res.append(this.nonce);
        res.append("\ncertReq:  ");
        res.append(this.certReq);
        res.append("\nextensions:  ");
        res.append(this.extensions);
        res.append("\n-- TimeStampReq End\n");
        return res.toString();
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this);
        }
        return this.encoding;
    }

    public Boolean getCertReq() {
        return this.certReq;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public String getReqPolicy() {
        return this.reqPolicy;
    }

    public int getVersion() {
        return this.version;
    }
}

