/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.plugin.api.PluginRepository;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.api.reader.RuleConfiguration;
import com.buschmais.jqassistant.core.rule.api.source.FileRuleSource;
import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import com.buschmais.jqassistant.core.rule.api.source.UrlRuleSource;
import com.buschmais.jqassistant.core.rule.impl.reader.RuleParser;
import com.buschmais.jqassistant.core.shared.option.OptionHelper;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.StoreConfiguration;
import com.buschmais.jqassistant.neo4j.backend.bootstrap.EmbeddedNeo4jConfiguration;
import com.buschmais.jqassistant.scm.maven.AbstractProjectMojo;
import com.buschmais.jqassistant.scm.maven.ProjectResolver;
import com.buschmais.jqassistant.scm.maven.StoreLifecycle;
import com.buschmais.jqassistant.scm.maven.provider.CachingStoreProvider;
import com.buschmais.jqassistant.scm.maven.provider.PluginRepositoryProvider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;

public abstract class AbstractMojo
extends org.apache.maven.plugin.AbstractMojo {
    public static final String PARAMETER_EMBEDDED_LISTEN_ADDRESS = "jqassistant.embedded.listenAddress";
    public static final String PARAMETER_EMBEDDED_BOLT_PORT = "jqassistant.embedded.boltPort";
    public static final String PARAMETER_EMBEDDED_HTTP_PORT = "jqassistant.embedded.httpPort";
    public static final String STORE_DIRECTORY = "jqassistant/store";
    public static final String PROPERTY_STORE_LIFECYCLE = "jqassistant.store.lifecycle";
    @Parameter(property="jqassistant.store.directory")
    protected File storeDirectory;
    @Parameter(property="jqassistant.store.uri")
    protected URI storeUri;
    @Parameter(property="jqassistant.store.username")
    protected String storeUserName;
    @Parameter(property="jqassistant.store.password")
    protected String storePassword;
    @Parameter(property="jqassistant.store.encryption")
    protected String storeEncryption;
    @Parameter(property="jqassistant.store.trustStrategy")
    protected String storeTrustStrategy;
    @Parameter(property="jqassistant.store.trustCertificate")
    protected String storeTrustCertificate;
    @Parameter
    protected StoreConfiguration store = StoreConfiguration.builder().build();
    @Parameter(property="jqassistant.embedded.listenAddress")
    protected String embeddedListenAddress;
    @Parameter(property="jqassistant.embedded.boltPort")
    protected Integer embeddedBoltPort;
    @Parameter(property="jqassistant.embedded.httpPort")
    protected Integer embeddedHttpPort;
    @Parameter
    private RuleConfiguration rule;
    @Parameter(property="jqassistant.useExecutionRootAsProjectRoot")
    protected boolean useExecutionRootAsProjectRoot = false;
    @Parameter(property="jqassistant.rules.directory", defaultValue="jqassistant")
    protected String rulesDirectory;
    @Parameter(property="jqassistant.rules.directories")
    protected List<String> rulesDirectories;
    @Parameter(property="jqassistant.rules.url")
    protected URL rulesUrl;
    @Parameter(property="jqassistant.concepts")
    protected List<String> concepts;
    @Parameter(property="jqassistant.constraints")
    protected List<String> constraints;
    @Parameter(property="jqassistant.groups")
    protected List<String> groups;
    @Parameter(property="jqassistant.report.xml")
    protected File xmlReportFile;
    @Parameter(property="jqassistant.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="jqassistant.store.lifecycle")
    protected StoreLifecycle storeLifecycle = StoreLifecycle.REACTOR;
    @Parameter(property="project")
    protected MavenProject currentProject;
    @Parameter(property="reactorProjects")
    protected List<MavenProject> reactorProjects;
    @Parameter(property="mojoExecution")
    protected MojoExecution execution;
    @Component
    protected PluginRepositoryProvider pluginRepositoryProvider;
    @Component
    private RuntimeInformation runtimeInformation;
    @Component
    private CachingStoreProvider cachingStoreProvider;

    private static String createExecutionKey(MojoExecution mojoExecution) {
        return mojoExecution.getGoal() + "@" + mojoExecution.getExecutionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.runtimeInformation.isMavenVersion("[3.5,)")) {
            throw new MojoExecutionException("jQAssistant requires Maven 3.5.x or above.");
        }
        Class<AbstractMojo> clazz = AbstractMojo.class;
        synchronized (AbstractMojo.class) {
            MavenProject rootModule = ProjectResolver.getRootModule(this.currentProject, this.reactorProjects, this.rulesDirectory, this.useExecutionRootAsProjectRoot);
            Set<MavenProject> executedModules = this.getExecutedModules(rootModule);
            if (this.skip) {
                this.getLog().info((CharSequence)"Skipping execution.");
            } else {
                this.execute(rootModule, executedModules);
            }
            executedModules.add(this.currentProject);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected abstract void execute(MavenProject var1, Set<MavenProject> var2) throws MojoExecutionException, MojoFailureException;

    protected abstract boolean isResetStoreBeforeExecution();

    protected abstract boolean isConnectorRequired();

    protected final RuleSet readRules(MavenProject rootModule) throws MojoExecutionException {
        Collection ruleParserPlugins;
        ArrayList<RuleSource> sources = new ArrayList<RuleSource>();
        PluginRepository pluginRepository = this.pluginRepositoryProvider.getPluginRepository();
        if (this.rulesUrl != null) {
            this.getLog().debug((CharSequence)("Retrieving rules from URL " + this.rulesUrl.toString()));
            sources.add((RuleSource)new UrlRuleSource(this.rulesUrl));
        } else {
            this.addRuleFiles(sources, ProjectResolver.getRulesDirectory(rootModule, this.rulesDirectory));
            if (this.rulesDirectories != null) {
                for (String directory : this.rulesDirectories) {
                    this.addRuleFiles(sources, ProjectResolver.getRulesDirectory(rootModule, directory));
                }
            }
            List ruleSources = pluginRepository.getRulePluginRepository().getRuleSources();
            sources.addAll(ruleSources);
        }
        try {
            ruleParserPlugins = pluginRepository.getRulePluginRepository().getRuleParserPlugins(this.getRuleConfiguration());
        }
        catch (RuleException e) {
            throw new MojoExecutionException("Cannot get rules rule source reader plugins.", (Exception)((Object)e));
        }
        try {
            RuleParser ruleParser = new RuleParser(ruleParserPlugins);
            return ruleParser.parse(sources);
        }
        catch (RuleException e) {
            throw new MojoExecutionException("Cannot read rules.", (Exception)((Object)e));
        }
    }

    protected final RuleConfiguration getRuleConfiguration() {
        Severity defaultConceptSeverity = RuleConfiguration.DEFAULT.getDefaultConceptSeverity();
        Severity defaultConstraintSeverity = RuleConfiguration.DEFAULT.getDefaultConstraintSeverity();
        Severity defaultGroupSeverity = RuleConfiguration.DEFAULT.getDefaultGroupSeverity();
        if (this.rule != null) {
            defaultConceptSeverity = this.rule.getDefaultConceptSeverity();
            defaultConstraintSeverity = this.rule.getDefaultConstraintSeverity();
            defaultGroupSeverity = this.rule.getDefaultGroupSeverity();
        }
        Severity effectiveConceptSeverity = defaultConceptSeverity != null ? defaultConceptSeverity : RuleConfiguration.DEFAULT.getDefaultConceptSeverity();
        Severity effectiveConstraintSeverity = defaultConstraintSeverity != null ? defaultConstraintSeverity : RuleConfiguration.DEFAULT.getDefaultConstraintSeverity();
        Severity effectiveGroupSeverity = defaultGroupSeverity != null ? defaultGroupSeverity : RuleConfiguration.DEFAULT.getDefaultGroupSeverity();
        return RuleConfiguration.builder().defaultConceptSeverity(effectiveConceptSeverity).defaultConstraintSeverity(effectiveConstraintSeverity).defaultGroupSeverity(effectiveGroupSeverity).build();
    }

    private void addRuleFiles(List<RuleSource> sources, File directory) throws MojoExecutionException {
        List<RuleSource> ruleSources = this.readRulesDirectory(directory);
        for (RuleSource ruleSource : ruleSources) {
            this.getLog().debug((CharSequence)("Adding rules from file " + ruleSource));
            sources.add(ruleSource);
        }
    }

    private List<RuleSource> readRulesDirectory(File rulesDirectory) throws MojoExecutionException {
        if (rulesDirectory.exists() && !rulesDirectory.isDirectory()) {
            throw new MojoExecutionException(rulesDirectory.getAbsolutePath() + " does not exist or is not a directory.");
        }
        this.getLog().info((CharSequence)("Reading rules from directory " + rulesDirectory.getAbsolutePath()));
        try {
            return FileRuleSource.getRuleSources((File)rulesDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read rulesDirectory: " + rulesDirectory.getAbsolutePath(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void execute(StoreOperation storeOperation, MavenProject rootModule, Set<MavenProject> executedModules) throws MojoExecutionException, MojoFailureException {
        Store store = this.getStore(rootModule);
        if (this.isResetStoreBeforeExecution() && executedModules.isEmpty()) {
            store.reset();
        }
        try {
            storeOperation.run(rootModule, store);
        }
        finally {
            this.releaseStore(store);
        }
    }

    private Set<MavenProject> getExecutedModules(MavenProject rootModule) {
        HashSet executedProjects;
        String executionKey = AbstractMojo.createExecutionKey(this.execution);
        String executedModulesContextKey = AbstractProjectMojo.class.getName() + "#executedModules";
        HashMap executedProjectsPerExecutionKey = (HashMap)rootModule.getContextValue(executedModulesContextKey);
        if (executedProjectsPerExecutionKey == null) {
            executedProjectsPerExecutionKey = new HashMap();
            rootModule.setContextValue(executedModulesContextKey, executedProjectsPerExecutionKey);
        }
        if ((executedProjects = (HashSet)executedProjectsPerExecutionKey.get(executionKey)) == null) {
            executedProjects = new HashSet();
            executedProjectsPerExecutionKey.put(executionKey, executedProjects);
        }
        return executedProjects;
    }

    private Store getStore(MavenProject rootModule) throws MojoExecutionException {
        PluginRepository pluginRepository;
        StoreConfiguration configuration = this.getStoreConfiguration(rootModule);
        Store existingStore = this.cachingStoreProvider.getStore(configuration, pluginRepository = this.pluginRepositoryProvider.getPluginRepository());
        if (!Store.class.isAssignableFrom(existingStore.getClass())) {
            throw new MojoExecutionException("Cannot re-use store instance from reactor. Either declare the plugin as extension or execute Maven using the property -Djqassistant.store.lifecycle=" + (Object)((Object)StoreLifecycle.MODULE) + " on the command line.");
        }
        return existingStore;
    }

    private void releaseStore(Store store) {
        switch (this.storeLifecycle) {
            case MODULE: {
                this.cachingStoreProvider.closeStore(store);
                break;
            }
        }
    }

    private StoreConfiguration getStoreConfiguration(MavenProject rootModule) {
        StoreConfiguration.StoreConfigurationBuilder builder = StoreConfiguration.builder();
        File storeDirectory = (File)OptionHelper.coalesce((Object[])new File[]{this.storeDirectory, new File(rootModule.getBuild().getDirectory(), STORE_DIRECTORY)});
        builder.uri((URI)OptionHelper.coalesce((Object[])new URI[]{this.storeUri, this.store.getUri(), new File(storeDirectory, "/").toURI()}));
        builder.username((String)OptionHelper.coalesce((Object[])new String[]{this.storeUserName, this.store.getUsername()}));
        builder.password((String)OptionHelper.coalesce((Object[])new String[]{this.storePassword, this.store.getPassword()}));
        builder.encryption((String)OptionHelper.coalesce((Object[])new String[]{this.storeEncryption, this.store.getEncryption()}));
        builder.trustStrategy((String)OptionHelper.coalesce((Object[])new String[]{this.storeTrustStrategy, this.store.getTrustStrategy()}));
        builder.trustCertificate((String)OptionHelper.coalesce((Object[])new String[]{this.storeTrustCertificate, this.store.getTrustCertificate()}));
        builder.properties(this.store.getProperties());
        builder.embedded(this.getEmbeddedNeo4jConfiguration());
        StoreConfiguration storeConfiguration = builder.build();
        this.getLog().debug((CharSequence)("Using store configuration " + storeConfiguration));
        return storeConfiguration;
    }

    private EmbeddedNeo4jConfiguration getEmbeddedNeo4jConfiguration() {
        EmbeddedNeo4jConfiguration embedded = this.store.getEmbedded();
        EmbeddedNeo4jConfiguration.EmbeddedNeo4jConfigurationBuilder builder = EmbeddedNeo4jConfiguration.builder();
        builder.connectorEnabled(embedded.isConnectorEnabled() || this.isConnectorRequired());
        builder.listenAddress((String)OptionHelper.coalesce((Object[])new String[]{this.embeddedListenAddress, embedded.getListenAddress()}));
        builder.boltPort((Integer)OptionHelper.coalesce((Object[])new Integer[]{this.embeddedBoltPort, embedded.getBoltPort()}));
        builder.httpPort((Integer)OptionHelper.coalesce((Object[])new Integer[]{this.embeddedHttpPort, embedded.getHttpPort()}));
        return builder.build();
    }

    protected static interface StoreOperation {
        public void run(MavenProject var1, Store var2) throws MojoExecutionException, MojoFailureException;
    }
}

