/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.analysis.api.AnalyzerConfiguration;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerImpl;
import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.impl.CompositeReportPlugin;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportPlugin;
import com.buschmais.jqassistant.core.report.impl.ReportContextImpl;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.api.reader.RuleConfiguration;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.maven.AbstractProjectMojo;
import com.buschmais.jqassistant.scm.maven.ProjectResolver;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="analyze", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, configurator="custom")
public class AnalyzeMojo
extends AbstractProjectMojo {
    public static final String JQASSISTANT_REPORT_CLASSIFIER = "jqassistant-report";
    private Logger logger = LoggerFactory.getLogger(AnalyzeMojo.class);
    @Parameter(property="jqassistant.ruleParameters")
    protected Map<String, String> ruleParameters;
    @Parameter(property="jqassistant.executeAppliedConcepts")
    protected boolean executeAppliedConcepts = false;
    @Parameter(property="jqassistant.warnOnSeverity")
    protected Severity warnOnSeverity = RuleConfiguration.DEFAULT.getDefaultConceptSeverity();
    @Parameter(property="jqassistant.failOnSeverity")
    protected Severity failOnSeverity = RuleConfiguration.DEFAULT.getDefaultConstraintSeverity();
    @Parameter(property="jqassistant.reportTypes")
    private Set<String> reportTypes;
    @Parameter(property="jqassistant.reportProperties")
    private Map<String, Object> reportProperties;
    @Parameter(property="jqassistant.attachReportArchive")
    private boolean attachReportArchive = false;
    @Component
    private MavenProjectHelper mavenProjectHelper;

    @Override
    protected boolean isResetStoreBeforeExecution() {
        return false;
    }

    @Override
    protected boolean isConnectorRequired() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(MavenProject rootModule, List<MavenProject> projects, Store store) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Executing analysis for '" + rootModule.getName() + "'."));
        this.getLog().info((CharSequence)("Will warn on violations starting from severity '" + this.warnOnSeverity + "'"));
        this.getLog().info((CharSequence)("Will fail on violations starting from severity '" + this.failOnSeverity + "'."));
        RuleSet ruleSet = this.readRules(rootModule);
        RuleSelection ruleSelection = RuleSelection.select((RuleSet)ruleSet, (List)this.groups, (List)this.constraints, (List)this.concepts);
        ReportContextImpl reportContext = new ReportContextImpl(store, ProjectResolver.getOutputDirectory(rootModule));
        Severity effectiveFailOnSeverity = this.failOnSeverity;
        Map<String, Object> properties = this.getReportProperties();
        Map reportPlugins = this.pluginRepositoryProvider.getPluginRepository().getAnalyzerPluginRepository().getReportPlugins((ReportContext)reportContext, properties);
        InMemoryReportPlugin inMemoryReportPlugin = new InMemoryReportPlugin((ReportPlugin)new CompositeReportPlugin(reportPlugins, this.reportTypes.isEmpty() ? null : this.reportTypes));
        AnalyzerConfiguration configuration = new AnalyzerConfiguration();
        configuration.setExecuteAppliedConcepts(this.executeAppliedConcepts);
        try {
            AnalyzerImpl analyzer = new AnalyzerImpl(configuration, store, this.pluginRepositoryProvider.getPluginRepository().getAnalyzerPluginRepository().getRuleInterpreterPlugins(Collections.emptyMap()), (ReportPlugin)inMemoryReportPlugin, this.logger);
            analyzer.execute(ruleSet, ruleSelection, this.ruleParameters);
        }
        catch (RuleException e) {
            throw new MojoExecutionException("Analysis failed.", (Exception)((Object)e));
        }
        if (this.attachReportArchive) {
            this.attachReportArchive(rootModule, (ReportContext)reportContext);
        }
        ReportHelper reportHelper = new ReportHelper(this.logger);
        store.beginTransaction();
        try {
            this.verifyAnalysisResults(inMemoryReportPlugin, reportHelper, effectiveFailOnSeverity);
        }
        finally {
            store.commitTransaction();
        }
    }

    private void attachReportArchive(MavenProject rootModule, ReportContext reportContext) throws MojoExecutionException {
        File reportArchive;
        try {
            reportArchive = reportContext.createReportArchive();
        }
        catch (ReportException e) {
            throw new MojoExecutionException("Cannot attach report artifact.", (Exception)((Object)e));
        }
        this.logger.info("Created report archive {}.", (Object)reportArchive);
        this.mavenProjectHelper.attachArtifact(rootModule, "zip", JQASSISTANT_REPORT_CLASSIFIER, reportArchive);
        if (!this.currentProject.equals((Object)rootModule)) {
            this.logger.info("Report archive has been attached to module '{}:{}:{}'. Use 'installAtEnd' (maven-install-plugin) or 'deployAtEnd' (maven-deploy-plugin) to ensure deployment to local or remote repositories.", new Object[]{rootModule.getGroupId(), rootModule.getArtifactId(), rootModule.getVersion()});
        }
    }

    private Map<String, Object> getReportProperties() {
        HashMap<String, Object> properties;
        HashMap<String, Object> hashMap = properties = this.reportProperties != null ? this.reportProperties : new HashMap<String, Object>();
        if (this.xmlReportFile != null) {
            properties.put("xml.report.file", this.xmlReportFile.getAbsolutePath());
        }
        return properties;
    }

    private void verifyAnalysisResults(InMemoryReportPlugin inMemoryReportWriter, ReportHelper reportHelper, Severity effectiveFailOnSeverity) throws MojoFailureException {
        boolean hasViolations;
        int conceptViolations = reportHelper.verifyConceptResults(this.warnOnSeverity, effectiveFailOnSeverity, inMemoryReportWriter);
        int constraintViolations = reportHelper.verifyConstraintResults(this.warnOnSeverity, effectiveFailOnSeverity, inMemoryReportWriter);
        boolean hasConceptViolations = conceptViolations > 0;
        boolean hasConstraintViolations = constraintViolations > 0;
        boolean bl = hasViolations = hasConceptViolations || hasConstraintViolations;
        if (hasViolations) {
            throw new MojoFailureException("Violations detected: " + conceptViolations + " concepts, " + constraintViolations + " constraints");
        }
    }
}

